/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAnimatedTorch;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;

public class TileLightRelay
extends TileMod
implements ITickableTileEntity,
IWandBindable {
    @ObjectHolder(value="botania:light_relay")
    public static TileEntityType<TileLightRelay> TYPE;
    private static final int MAX_DIST = 20;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private BlockPos bindPos = new BlockPos(0, -1, 0);
    private int ticksElapsed = 0;

    public TileLightRelay() {
        super(TYPE);
    }

    public void mountEntity(Entity e) {
        BlockPos nextDest = this.getNextDestination();
        if (e.func_184218_aH() || this.field_145850_b.field_72995_K || nextDest == null || !this.isValidBinding()) {
            return;
        }
        EntityPlayerMover mover = new EntityPlayerMover(this.field_145850_b, this.field_174879_c, nextDest);
        this.field_145850_b.func_217376_c((Entity)mover);
        e.func_184220_m((Entity)mover);
        if (!(e instanceof ItemEntity)) {
            mover.func_184185_a(ModSounds.lightRelay, 0.2f, (float)Math.random() * 0.3f + 0.7f);
        }
        if (e instanceof ServerPlayerEntity) {
            PlayerHelper.grantCriterion((ServerPlayerEntity)e, new ResourceLocation("botania", "main/luminizer_ride"), "code_triggered");
        }
    }

    public void func_73660_a() {
        block3: {
            block4: {
                ++this.ticksElapsed;
                BlockPos nextDest = this.getNextDestination();
                if (nextDest == null || nextDest.func_177956_o() <= -1 || !this.isValidBinding()) break block3;
                if (!this.field_145850_b.field_72995_K) break block4;
                Vector3 vec = this.getMovementVector();
                if (vec == null) break block3;
                double dist = 0.1;
                int size = (int)(vec.mag() / dist);
                int count = 10;
                int start = this.ticksElapsed % size;
                Vector3 vecMag = vec.normalize().multiply(dist);
                Vector3 vecTip = vecMag.multiply(start).add((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                double radPer = 0.19634954084936207;
                float mul = 0.5f;
                float mulPer = 0.4f;
                float maxMul = 2.0f;
                WispParticleData data = WispParticleData.wisp(0.1f, 0.4f, 0.4f, 1.0f, 1.0f);
                for (int i = start; i < start + count; ++i) {
                    mul = Math.min(maxMul, mul + mulPer);
                    double rad = radPer * ((double)i + (double)this.ticksElapsed * 0.4);
                    Vector3 vecRot = vecMag.crossProduct(Vector3.ONE).multiply(mul).rotate(rad, vecMag).add(vecTip);
                    this.field_145850_b.func_195594_a((IParticleData)data, vecRot.x, vecRot.y, vecRot.z, (double)((float)(-vecMag.x)), (double)((float)(-vecMag.y)), (double)((float)(-vecMag.z)));
                    vecTip = vecTip.add(vecMag);
                }
                break block3;
            }
            BlockPos endpoint = this.getEndpoint();
            if (endpoint != null) {
                AxisAlignedBB aabb = this.field_145850_b.func_180495_p(this.field_174879_c).func_196954_c((IBlockReader)this.field_145850_b, this.field_174879_c).func_197752_a().func_186670_a(this.field_174879_c);
                float range = 0.5f;
                List enderPearls = this.field_145850_b.func_217357_a(EnderPearlEntity.class, aabb.func_186662_g((double)range));
                for (EnderPearlEntity pearl : enderPearls) {
                    pearl.func_70634_a((double)endpoint.func_177958_n() + pearl.field_70165_t - (double)this.field_174879_c.func_177958_n(), (double)endpoint.func_177956_o() + pearl.field_70163_u - (double)this.field_174879_c.func_177956_o(), (double)endpoint.func_177952_p() + pearl.field_70161_v - (double)this.field_174879_c.func_177952_p());
                }
            }
        }
    }

    private boolean isValidBinding() {
        BlockPos nextDest = this.getNextDestination();
        if (nextDest == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(nextDest).func_177230_c();
        return block instanceof BlockLightRelay;
    }

    private BlockPos getEndpoint() {
        ArrayList<TileLightRelay> pointsPassed = new ArrayList<TileLightRelay>();
        TileLightRelay relay = this;
        BlockPos lastCoords = null;
        boolean run = true;
        while (run) {
            if (pointsPassed.contains(relay)) {
                return null;
            }
            pointsPassed.add(relay);
            BlockPos coords = relay.getNextDestination();
            if (coords == null) {
                return lastCoords;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(coords);
            if (tile == null || !(tile instanceof TileLightRelay)) {
                return lastCoords;
            }
            relay = (TileLightRelay)tile;
            lastCoords = coords;
        }
        return null;
    }

    public Vector3 getMovementVector() {
        BlockPos dest = this.getNextDestination();
        if (dest == null) {
            return null;
        }
        return new Vector3(dest.func_177958_n() - this.field_174879_c.func_177958_n(), dest.func_177956_o() - this.field_174879_c.func_177956_o(), dest.func_177952_p() - this.field_174879_c.func_177952_p());
    }

    @Override
    public BlockPos getBinding() {
        return this.bindPos;
    }

    public BlockPos getNextDestination() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == ModBlocks.lightRelayToggle && ((Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED)).booleanValue()) {
            return null;
        }
        if (state.func_177230_c() == ModBlocks.lightRelayFork) {
            BlockPos torchPos = null;
            for (int i = -2; i < 3; ++i) {
                BlockPos testPos = this.field_174879_c.func_177982_a(0, i, 0);
                BlockState testState = this.field_145850_b.func_180495_p(testPos);
                if (testState.func_177230_c() != ModBlocks.animatedTorch) continue;
                torchPos = testPos;
                break;
            }
            if (torchPos != null) {
                TileAnimatedTorch torch = (TileAnimatedTorch)this.field_145850_b.func_175625_s(torchPos);
                Direction side = TileAnimatedTorch.SIDES[torch.side].func_176734_d();
                for (int i = 1; i < 20; ++i) {
                    BlockPos testPos = this.field_174879_c.func_177967_a(side, i);
                    BlockState testState = this.field_145850_b.func_180495_p(testPos);
                    if (!(testState.func_177230_c() instanceof BlockLightRelay)) continue;
                    return testPos;
                }
            }
        }
        return this.getBinding();
    }

    @Override
    public boolean canSelect(PlayerEntity player, ItemStack wand, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public boolean bindTo(PlayerEntity player, ItemStack wand, BlockPos pos, Direction side) {
        if (!(player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockLightRelay) || pos.func_177951_i((Vec3i)this.func_174877_v()) > 400.0) {
            return false;
        }
        this.bindPos = pos;
        return true;
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.bindPos = new BlockPos(cmp.func_74762_e(TAG_BIND_X), cmp.func_74762_e(TAG_BIND_Y), cmp.func_74762_e(TAG_BIND_Z));
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_BIND_X, this.bindPos.func_177958_n());
        cmp.func_74768_a(TAG_BIND_Y, this.bindPos.func_177956_o());
        cmp.func_74768_a(TAG_BIND_Z, this.bindPos.func_177952_p());
    }

    public static class EntityPlayerMover
    extends Entity {
        @ObjectHolder(value="botania:player_mover")
        public static EntityType<EntityPlayerMover> TYPE;
        private static final String TAG_EXIT_X = "exitX";
        private static final String TAG_EXIT_Y = "exitY";
        private static final String TAG_EXIT_Z = "exitZ";
        private static final DataParameter<BlockPos> EXIT_POS;

        public EntityPlayerMover(EntityType<EntityPlayerMover> type, World world) {
            super(type, world);
            this.field_70145_X = true;
        }

        public EntityPlayerMover(World world, BlockPos pos, BlockPos exitPos) {
            this(TYPE, world);
            this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.setExit(exitPos);
        }

        protected void func_70088_a() {
            this.field_70180_af.func_187214_a(EXIT_POS, (Object)BlockPos.field_177992_a);
        }

        public void func_70071_h_() {
            BlockPos exitPos;
            BlockPos pos;
            super.func_70071_h_();
            if (this.func_184188_bt().isEmpty() && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
            boolean isItem = this.func_184187_bx() instanceof ItemEntity;
            if (!isItem && this.field_70173_aa % 30 == 0) {
                this.func_184185_a(ModSounds.lightRelay, 0.05f, (float)Math.random() * 0.3f + 0.7f);
            }
            if ((pos = new BlockPos((Entity)this)).equals((Object)(exitPos = this.getExitPos()))) {
                TileEntity tile = this.field_70170_p.func_175625_s(pos);
                if (tile instanceof TileLightRelay) {
                    TileLightRelay relay;
                    BlockPos bind;
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() == ModBlocks.lightRelayDetector) {
                        this.field_70170_p.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)));
                        this.field_70170_p.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), state.func_177230_c().func_149738_a((IWorldReader)this.field_70170_p));
                    }
                    if ((bind = (relay = (TileLightRelay)tile).getNextDestination()) != null && relay.isValidBinding()) {
                        this.setExit(bind);
                        return;
                    }
                }
                for (Entity e : this.func_184188_bt()) {
                    e.func_184210_p();
                    e.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                this.func_70106_y();
            } else {
                Vector3 thisVec = Vector3.fromEntity(this);
                Vector3 motVec = thisVec.negate().add((double)exitPos.func_177958_n() + 0.5, (double)exitPos.func_177956_o() + 0.5, (double)exitPos.func_177952_p() + 0.5).normalize().multiply(0.5);
                int count = 4;
                for (int i = 0; i < count; ++i) {
                    Color color = Color.getHSBColor((float)this.field_70173_aa / 36.0f + 1.0f / (float)count * (float)i, 1.0f, 1.0f);
                    double rad = Math.PI * 2 / (double)count * (double)i + (double)this.field_70173_aa / Math.PI;
                    double cos = Math.cos(rad);
                    double sin = Math.sin(rad);
                    double s = 0.4;
                    SparkleParticleData data = SparkleParticleData.sparkle(1.2f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 10);
                    this.field_70170_p.func_195594_a((IParticleData)data, this.field_70165_t + cos * s, this.field_70163_u - 0.5, this.field_70161_v + sin * s, 0.0, 0.0, 0.0);
                }
                this.field_70165_t += motVec.x;
                this.field_70163_u += motVec.y;
                this.field_70161_v += motVec.z;
            }
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public boolean func_70097_a(@Nonnull DamageSource source, float damage) {
            return false;
        }

        protected void func_70037_a(@Nonnull CompoundNBT cmp) {
            this.setExit(new BlockPos(cmp.func_74762_e(TAG_EXIT_X), cmp.func_74762_e(TAG_EXIT_Y), cmp.func_74762_e(TAG_EXIT_Z)));
        }

        protected void func_213281_b(@Nonnull CompoundNBT cmp) {
            BlockPos exit = this.getExitPos();
            cmp.func_74768_a(TAG_EXIT_X, exit.func_177958_n());
            cmp.func_74768_a(TAG_EXIT_Y, exit.func_177956_o());
            cmp.func_74768_a(TAG_EXIT_Z, exit.func_177952_p());
        }

        @Nonnull
        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        public BlockPos getExitPos() {
            return (BlockPos)this.field_70180_af.func_187225_a(EXIT_POS);
        }

        public void setExit(BlockPos pos) {
            this.field_70180_af.func_187227_b(EXIT_POS, (Object)pos);
        }

        static {
            EXIT_POS = EntityDataManager.func_187226_a(EntityPlayerMover.class, (IDataSerializer)DataSerializers.field_187200_j);
        }
    }
}

