/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.lib.ModTags;

public class SubTileRafflowsia
extends TileEntityGeneratingFlower {
    @ObjectHolder(value="botania:rafflowsia")
    public static TileEntityType<SubTileRafflowsia> TYPE;
    public static final String TAG_LAST_FLOWER = "lastFlower";
    public static final String TAG_LAST_FLOWER_TIMES = "lastFlowerTimes";
    @Nullable
    private Block lastFlower;
    private int lastFlowerTimes;
    private static final int RANGE = 5;

    public SubTileRafflowsia() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        int mana = 2100;
        if (this.getMaxMana() - this.getMana() >= mana && !this.func_145831_w().field_72995_K && this.ticksExisted % 40 == 0) {
            for (int i = 0; i < 11; ++i) {
                for (int j = 0; j < 11; ++j) {
                    for (int k = 0; k < 11; ++k) {
                        BlockPos pos = this.func_174877_v().func_177982_a(i - 5, j - 5, k - 5);
                        BlockState state = this.func_145831_w().func_180495_p(pos);
                        if (!state.func_203425_a(ModTags.Blocks.SPECIAL_FLOWERS) || state.func_177230_c() == ModSubtiles.rafflowsia) continue;
                        if (state.func_177230_c() == this.lastFlower) {
                            ++this.lastFlowerTimes;
                        } else {
                            this.lastFlower = state.func_177230_c();
                            this.lastFlowerTimes = 1;
                        }
                        float mod = 1.0f / (float)this.lastFlowerTimes;
                        this.func_145831_w().func_175655_b(pos, false);
                        this.addMana((int)((float)mana * mod));
                        this.sync();
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        if (this.lastFlower != null) {
            cmp.func_74778_a(TAG_LAST_FLOWER, this.lastFlower.getRegistryName().toString());
        }
        cmp.func_74768_a(TAG_LAST_FLOWER_TIMES, this.lastFlowerTimes);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        ResourceLocation id = ResourceLocation.func_208304_a((String)cmp.func_74779_i(TAG_LAST_FLOWER));
        if (id != null) {
            this.lastFlower = (Block)ForgeRegistries.BLOCKS.getValue(id);
        }
        this.lastFlowerTimes = cmp.func_74762_e(TAG_LAST_FLOWER_TIMES);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.func_174877_v(), 5);
    }

    @Override
    public int getColor() {
        return 5254262;
    }

    @Override
    public int getMaxMana() {
        return 9000;
    }
}

