/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;

public class SubTileOrechid
extends TileEntityFunctionalFlower {
    @ObjectHolder(value="botania:orechid")
    public static TileEntityType<SubTileOrechid> TYPE;
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;
    private static final int TRIES = 20;

    public SubTileOrechid(TileEntityType<?> type) {
        super(type);
    }

    public SubTileOrechid() {
        this(TYPE);
    }

    @Override
    public void tickFlower() {
        BlockState state;
        BlockPos coords;
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        int cost = this.getCost();
        if (this.getMana() >= cost && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null && (state = this.getOreToPut()) != null) {
            this.func_145831_w().func_175656_a(coords, state);
            if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)state));
            }
            this.func_145831_w().func_184133_a(null, coords, ModSounds.orechid, SoundCategory.BLOCKS, 2.0f, 1.0f);
            this.addMana(-cost);
            this.sync();
        }
    }

    @Nullable
    private BlockState getOreToPut() {
        Map<ResourceLocation, Integer> map = this.getOreMap();
        List values = map.entrySet().stream().map(e -> new TagRandomItem((Integer)e.getValue(), (ResourceLocation)e.getKey())).collect(Collectors.toList());
        if (WeightedRandom.func_76272_a(values) == 0) {
            return null;
        }
        for (int i = 0; i < 20; ++i) {
            ResourceLocation ore = ((TagRandomItem)WeightedRandom.func_76271_a((Random)this.func_145831_w().field_73012_v, values)).s;
            Tag tag = BlockTags.func_199896_a().func_199910_a(ore);
            if (tag == null || tag.func_199885_a().isEmpty()) continue;
            return ((Block)tag.func_205596_a(this.func_145831_w().func_201674_k())).func_176223_P();
        }
        return null;
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.func_174877_v().func_177982_a(-5, -3, -5), (BlockPos)this.func_174877_v().func_177982_a(5, 3, 5))) {
            BlockState state = this.func_145831_w().func_180495_p(pos);
            if (!state.func_177230_c().isReplaceableOreGen(state, (IWorldReader)this.func_145831_w(), pos, this.getReplaceMatcher())) continue;
            possibleCoords.add(pos.func_185334_h());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.func_145831_w().field_73012_v.nextInt(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public Map<ResourceLocation, Integer> getOreMap() {
        return BotaniaAPI.oreWeights;
    }

    public Predicate<BlockState> getReplaceMatcher() {
        return state -> state.func_177230_c() == Blocks.field_150348_b;
    }

    public int getCost() {
        return Botania.gardenOfGlassLoaded ? 700 : 17500;
    }

    public int getDelay() {
        return Botania.gardenOfGlassLoaded ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.func_174877_v(), 5);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }

    private static class TagRandomItem
    extends WeightedRandom.Item {
        public final ResourceLocation s;

        public TagRandomItem(int weight, ResourceLocation s) {
            super(weight);
            this.s = s;
        }
    }
}

