/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.lib.ModTags;

@Mod.EventBusSubscriber(modid="botania")
public class SubTileLoonuim
extends TileEntityFunctionalFlower {
    @ObjectHolder(value="botania:loonium")
    public static TileEntityType<SubTileLoonuim> TYPE;
    private static final int COST = 35000;
    private static final int RANGE = 5;
    private static final String TAG_LOOT_TABLE = "lootTable";
    private static final String TAG_ITEMSTACK_TO_DROP = "botania:looniumItemStackToDrop";
    private ResourceLocation lootTable = new ResourceLocation("minecraft", "chests/simple_dungeon");

    public SubTileLoonuim() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        World world = this.func_145831_w();
        if (!world.field_72995_K && this.redstoneSignal == 0 && this.ticksExisted % 100 == 0 && this.getMana() >= 35000) {
            List stacks;
            ItemStack stack;
            Random rand = world.field_73012_v;
            do {
                LootContext ctx = new LootContext.Builder((ServerWorld)world).func_216022_a(LootParameterSets.field_216260_a);
                stacks = ((ServerWorld)world).func_73046_m().func_200249_aQ().func_186521_a(this.lootTable).func_216113_a(ctx);
                if (stacks.isEmpty()) {
                    return;
                }
                Collections.shuffle(stacks);
            } while ((stack = (ItemStack)stacks.get(0)).func_190926_b() || ModTags.Items.LOONIUM_BLACKLIST.func_199685_a_((Object)stack.func_77973_b()));
            int bound = 11;
            int xp = this.func_174877_v().func_177958_n() - 5 + rand.nextInt(bound);
            int yp = this.func_174877_v().func_177956_o();
            int zp = this.func_174877_v().func_177952_p() - 5 + rand.nextInt(bound);
            BlockPos pos = new BlockPos(xp, yp - 1, zp);
            do {
                if ((pos = pos.func_177984_a()).func_177956_o() < 254) continue;
                return;
            } while (world.func_180495_p(pos).func_215696_m((IBlockReader)world, pos));
            pos = pos.func_177984_a();
            double x = (double)pos.func_177958_n() + Math.random();
            double y = (double)pos.func_177956_o() + Math.random();
            double z = (double)pos.func_177952_p() + Math.random();
            Object entity = null;
            if (world.field_73012_v.nextInt(50) == 0) {
                entity = new EndermanEntity(EntityType.field_200803_q, world);
            } else if (world.field_73012_v.nextInt(10) == 0) {
                entity = new CreeperEntity(EntityType.field_200797_k, world);
                if (world.field_73012_v.nextInt(200) == 0) {
                    entity.func_70077_a(null);
                }
            } else {
                switch (world.field_73012_v.nextInt(3)) {
                    case 0: {
                        if (world.field_73012_v.nextInt(10) == 0) {
                            entity = new HuskEntity(EntityType.field_200763_C, world);
                            break;
                        }
                        entity = new ZombieEntity(world);
                        break;
                    }
                    case 1: {
                        if (world.field_73012_v.nextInt(10) == 0) {
                            entity = new StrayEntity(EntityType.field_200750_ap, world);
                            break;
                        }
                        entity = new SkeletonEntity(EntityType.field_200741_ag, world);
                        break;
                    }
                    case 2: {
                        entity = world.field_73012_v.nextInt(10) == 0 ? new CaveSpiderEntity(EntityType.field_200794_h, world) : new SpiderEntity(EntityType.field_200748_an, world);
                    }
                }
            }
            entity.func_70080_a(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            entity.func_213317_d(Vec3d.field_186680_a);
            HashMultimap map = HashMultimap.create();
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("Loonium Modififer Health", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier("Loonium Modififer Damage", 1.5, AttributeModifier.Operation.MULTIPLY_BASE));
            entity.func_110140_aT().func_111147_b((Multimap)map);
            entity.func_195064_c(new EffectInstance(Effects.field_76426_n, entity instanceof CreeperEntity ? 100 : Integer.MAX_VALUE, 0));
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, entity instanceof CreeperEntity ? 100 : Integer.MAX_VALUE, 0));
            CompoundNBT cmp = stack.func_77955_b(new CompoundNBT());
            entity.getPersistentData().func_218657_a(TAG_ITEMSTACK_TO_DROP, (INBT)cmp);
            entity.func_213386_a((IWorld)world, world.func_175649_E(pos), SpawnReason.SPAWNER, null, null);
            world.func_217376_c((Entity)entity);
            entity.func_70656_aK();
            this.addMana(-35000);
            this.sync();
        }
    }

    @Override
    public int getColor() {
        return 2574848;
    }

    @Override
    public int getMaxMana() {
        return 35000;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.func_174877_v(), 5);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.func_74764_b(TAG_LOOT_TABLE)) {
            this.lootTable = new ResourceLocation(cmp.func_74779_i(TAG_LOOT_TABLE));
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74778_a(TAG_LOOT_TABLE, this.lootTable.toString());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDrops(LivingDropsEvent event) {
        LivingEntity e = event.getEntityLiving();
        if (e.getPersistentData().func_74764_b(TAG_ITEMSTACK_TO_DROP)) {
            CompoundNBT cmp = e.getPersistentData().func_74775_l(TAG_ITEMSTACK_TO_DROP);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)cmp);
            event.getDrops().clear();
            event.getDrops().add(new ItemEntity(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, stack));
        }
    }
}

