/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.orechid;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.integration.jei.JEIBotaniaPlugin;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeWrapper;
import vazkii.botania.common.block.ModSubtiles;

public class OrechidRecipeCategory
implements IRecipeCategory<OrechidRecipeWrapper> {
    public static final ResourceLocation UID = new ResourceLocation("botania", "orechid");
    private final IDrawableStatic background;
    private final String localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;

    public OrechidRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 64);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.orechid", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 46);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModSubtiles.orechid));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends OrechidRecipeWrapper> getRecipeClass() {
        return OrechidRecipeWrapper.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(OrechidRecipeWrapper recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)Blocks.field_150348_b, 64));
        int myWeight = recipe.entry.getValue();
        int amount = Math.max(1, Math.round((float)myWeight * 64.0f / OrechidRecipeCategory.getTotalOreWeight(BotaniaAPI.oreWeights, myWeight)));
        List<ItemStack> stackList = BlockTags.func_199896_a().func_199915_b(recipe.entry.getKey()).func_199885_a().stream().filter(s -> s.func_199767_j() != Items.field_190931_a).map(ItemStack::new).collect(Collectors.toList());
        stackList.forEach(s -> s.func_190920_e(amount));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(stackList));
    }

    public static float getTotalOreWeight(Map<ResourceLocation, Integer> weights, int myWeight) {
        return weights.entrySet().stream().filter(e -> JEIBotaniaPlugin.doesOreExist((ResourceLocation)e.getKey())).map(Map.Entry::getValue).reduce(Integer::sum).orElse(myWeight * 64 * 64).intValue();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull OrechidRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 40, 12);
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.init(1, true, 70, 12);
        itemStacks.set(1, new ItemStack((IItemProvider)ModSubtiles.orechid));
        itemStacks.init(2, true, 99, 12);
        itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(OrechidRecipeWrapper recipe, double mouseX, double mouseY) {
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        this.overlay.draw(48, 0);
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
    }
}

