/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IItemProvider;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ModTags;

public final class ContributorFancinessHandler
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public static final Map<String, ItemStack> flowerMap = new HashMap<String, ItemStack>();
    private static boolean startedLoading = false;
    private static final ImmutableMap<String, String> LEGACY_FLOWER_NAMES = ImmutableMap.builder().put((Object)"puredaisy", (Object)LibBlockNames.SUBTILE_PUREDAISY.func_110623_a()).put((Object)"fallenkanade", (Object)LibBlockNames.SUBTILE_FALLEN_KANADE.func_110623_a()).put((Object)"heiseidream", (Object)LibBlockNames.SUBTILE_HEISEI_DREAM.func_110623_a()).put((Object)"arcanerose", (Object)LibBlockNames.SUBTILE_ARCANE_ROSE.func_110623_a()).put((Object)"jadedamaranthus", (Object)LibBlockNames.SUBTILE_JADED_AMARANTHUS.func_110623_a()).put((Object)"orechidignem", (Object)LibBlockNames.SUBTILE_ORECHID_IGNEM.func_110623_a()).build();

    public ContributorFancinessHandler(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
        super(renderer);
    }

    public void render(@Nonnull AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (player.func_82150_aj()) {
            return;
        }
        String name = player.func_145748_c_().getString();
        GlStateManager.pushMatrix();
        AccessoryRenderHelper.translateToHeadLevel((LivingEntity)player, partialTicks);
        if (name.equals("haighyorkie")) {
            ContributorFancinessHandler.renderGoldfish((PlayerEntity)player);
        }
        ContributorFancinessHandler.firstStart();
        name = name.toLowerCase();
        if (player.func_175148_a(PlayerModelPart.CAPE) && flowerMap.containsKey(name)) {
            ContributorFancinessHandler.renderFlower((PlayerEntity)player, flowerMap.get(name), partialTicks);
        }
        GlStateManager.popMatrix();
    }

    public boolean func_177142_b() {
        return false;
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static void load(Properties props) {
        flowerMap.clear();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 16) {
                    throw new NumberFormatException();
                }
                flowerMap.put(key, new ItemStack((IItemProvider)ModBlocks.getFlower(DyeColor.func_196056_a((int)i))));
            }
            catch (NumberFormatException e) {
                String rawName = value.toLowerCase(Locale.ROOT);
                String flowerName = (String)LEGACY_FLOWER_NAMES.getOrDefault((Object)rawName, (Object)rawName);
                Item item = ModTags.Items.SPECIAL_FLOWERS.func_199885_a().stream().filter(flower -> flower.getRegistryName().func_110623_a().equals(flowerName)).findFirst().orElse(Items.field_221620_aV);
                flowerMap.put(key, new ItemStack((IItemProvider)item));
            }
        }
    }

    private static void renderGoldfish(PlayerEntity player) {
        GlStateManager.pushMatrix();
        TextureAtlasSprite icon = MiscellaneousIcons.INSTANCE.goldfishIcon;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        GlStateManager.translatef((float)0.0f, (float)player.func_70047_e(), (float)0.0f);
        AccessoryRenderHelper.rotateIfSneaking((LivingEntity)player);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)0.4f, (float)0.4f, (float)0.4f);
        GlStateManager.translatef((float)-0.5f, (float)1.6f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
        GlStateManager.popMatrix();
    }

    private static void renderFlower(PlayerEntity player, ItemStack flower, float partialTicks) {
        GlStateManager.pushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translated((double)0.0, (double)-0.85, (double)0.0);
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
        ShaderHelper.useShader(ShaderHelper.gold);
        Minecraft.func_71410_x().func_175599_af().func_184392_a(flower, (LivingEntity)player, ItemCameraTransforms.TransformType.NONE, false);
        ShaderHelper.releaseShader();
        GlStateManager.popMatrix();
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Botania Contributor Fanciness Thread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(Botania.LOGGER));
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    props.load(reader);
                    ContributorFancinessHandler.load(props);
                }
            }
            catch (IOException e) {
                Botania.LOGGER.info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
            }
        }
    }
}

