/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.common.item.ModItems;

public final class BaubleRenderHandler
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public BaubleRenderHandler(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
        super(renderer);
    }

    public void render(@Nonnull AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.dispatchRenders((PlayerEntity)player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private void dispatchRenders(PlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            SortedMap curios = handler.getCurioMap();
            if (player.func_70093_af()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            for (Map.Entry e : curios.entrySet()) {
                for (int i = 0; i < ((CurioStackHandler)e.getValue()).getSlots(); ++i) {
                    IPhantomInkable inkable;
                    Item item;
                    ItemStack stack = ((CurioStackHandler)e.getValue()).getStackInSlot(i);
                    if (stack.func_190926_b() || (item = stack.func_77973_b()) instanceof IPhantomInkable && (inkable = (IPhantomInkable)item).hasPhantomInk(stack) || !(item instanceof ICosmeticAttachable)) continue;
                    ICosmeticAttachable attachable = (ICosmeticAttachable)item;
                    ItemStack cosmetic = attachable.getCosmeticItem(stack);
                    cosmetic.getCapability(CuriosCapability.ITEM).ifPresent(c -> {
                        if (c.hasRender((String)e.getKey(), (LivingEntity)player)) {
                            GlStateManager.pushMatrix();
                            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            c.doRender((String)e.getKey(), (LivingEntity)player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                            GlStateManager.popMatrix();
                        }
                    });
                }
            }
        });
        GlStateManager.popMatrix();
    }

    private void renderManaTablet(PlayerEntity player) {
        boolean renderedOne = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.manaTablet) continue;
            GlStateManager.pushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            AccessoryRenderHelper.rotateIfSneaking((LivingEntity)player);
            boolean armor = !player.func_184582_a(EquipmentSlotType.LEGS).func_190926_b();
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translated((double)0.0, (double)-0.6, (double)0.0);
            GlStateManager.scaled((double)0.55, (double)0.55, (double)0.55);
            if (renderedOne) {
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(armor ? 0.55f : 0.5f));
            } else {
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(armor ? -0.55f : -0.5f));
            }
            GlStateManager.scalef((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            int light = 0xF000F0;
            int lightmapX = light % 65536;
            int lightmapY = light / 65536;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.popMatrix();
            if (renderedOne) {
                return;
            }
            renderedOne = true;
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

