/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;

public class RecipePureDaisy {
    public static final int DEFAULT_TIME = 150;
    private final ResourceLocation id;
    private final Object input;
    private final BlockState outputState;
    private final int time;

    public RecipePureDaisy(ResourceLocation id, Object input, BlockState state) {
        this(id, input, state, 150);
    }

    public RecipePureDaisy(ResourceLocation id, Object input, BlockState state, int time) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
        this.id = id;
        this.input = input;
        this.outputState = state;
        this.time = time;
        if (!(input == null || input instanceof Block || input instanceof BlockState || input instanceof Tag && RecipePureDaisy.checkBlockTag((Tag)input))) {
            throw new IllegalArgumentException("input must be a Tag<Block>, Block, or IBlockState");
        }
    }

    private static boolean checkBlockTag(Tag<?> tag) {
        return tag.func_199885_a().stream().allMatch(o -> o instanceof Block);
    }

    public boolean matches(World world, BlockPos pos, TileEntitySpecialFlower pureDaisy, BlockState state) {
        if (this.input instanceof Block) {
            return state.func_177230_c() == this.input;
        }
        if (this.input instanceof BlockState) {
            return state == this.input;
        }
        return ((Tag)this.input).func_199685_a_((Object)state.func_177230_c());
    }

    public boolean set(World world, BlockPos pos, TileEntitySpecialFlower pureDaisy) {
        if (!world.field_72995_K) {
            world.func_175656_a(pos, this.outputState);
        }
        return true;
    }

    public Object getInput() {
        return this.input;
    }

    public BlockState getOutputState() {
        return this.outputState;
    }

    public int getTime() {
        return this.time;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        if (this.input instanceof Tag) {
            buf.func_150787_b(0);
            buf.func_192572_a(((Tag)this.input).func_199886_b());
        } else if (this.input instanceof Block) {
            buf.func_150787_b(1);
            buf.func_150787_b(Registry.field_212618_g.func_148757_b((Object)((Block)this.input)));
        } else {
            buf.func_150787_b(2);
            buf.func_150787_b(Block.func_196246_j((BlockState)((BlockState)this.input)));
        }
        buf.func_150787_b(Block.func_196246_j((BlockState)this.outputState));
        buf.func_150787_b(this.time);
    }

    public static RecipePureDaisy read(PacketBuffer buf) {
        Object input;
        ResourceLocation id = buf.func_192575_l();
        switch (buf.func_150792_a()) {
            case 0: {
                input = new BlockTags.Wrapper(buf.func_192575_l());
                break;
            }
            case 1: {
                input = Registry.field_212618_g.func_148745_a(buf.func_150792_a());
                break;
            }
            case 2: {
                input = Block.func_196257_b((int)buf.func_150792_a());
                break;
            }
            default: {
                throw new RuntimeException("Unknown input discriminator");
            }
        }
        BlockState output = Block.func_196257_b((int)buf.func_150792_a());
        int time = buf.func_150792_a();
        return new RecipePureDaisy(id, input, output, time);
    }
}

