/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelicBauble;

@Mod.EventBusSubscriber(modid="botania")
public class ItemOdinRing
extends ItemRelicBauble {
    private static final Set<String> damageNegations = new HashSet<String>();
    private static final Set<String> fireNegations = new HashSet<String>();

    public ItemOdinRing(Item.Properties props) {
        super(props);
        damageNegations.add(DamageSource.field_76369_e.field_76373_n);
        damageNegations.add(DamageSource.field_76379_h.field_76373_n);
        damageNegations.add(DamageSource.field_76371_c.field_76373_n);
        damageNegations.add(DamageSource.field_76368_d.field_76373_n);
        damageNegations.add(DamageSource.field_76366_f.field_76373_n);
        fireNegations.add(DamageSource.field_76372_a.field_76373_n);
        fireNegations.add(DamageSource.field_76370_b.field_76373_n);
    }

    @Override
    public void onValidPlayerWornTick(PlayerEntity player) {
        if (player.func_70027_ad() && ((Boolean)ConfigHandler.COMMON.ringOfOdinFireResist.get()).booleanValue()) {
            player.func_70066_B();
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ItemOdinRing.getBaubleUUID(stack), "Odin Ring", 20.0, AttributeModifier.Operation.ADDITION).func_111168_a(false));
        return attributes;
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            boolean hasRing;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            boolean negate = damageNegations.contains(event.getSource().field_76373_n) || (Boolean)ConfigHandler.COMMON.ringOfOdinFireResist.get() != false && fireNegations.contains(event.getSource().field_76373_n);
            boolean bl = hasRing = !EquipmentHandler.findOrEmpty(ModItems.odinRing, (LivingEntity)player).func_190926_b();
            if (hasRing && negate) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/odin_ring");
    }
}

