/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelicBauble;

@Mod.EventBusSubscriber(modid="botania")
public class ItemLokiRing
extends ItemRelicBauble
implements IWireframeCoordinateListProvider,
IManaUsingItem {
    private static final String TAG_CURSOR_LIST = "cursorList";
    private static final String TAG_CURSOR_PREFIX = "cursor";
    private static final String TAG_CURSOR_COUNT = "cursorCount";
    private static final String TAG_X_OFFSET = "xOffset";
    private static final String TAG_Y_OFFSET = "yOffset";
    private static final String TAG_Z_OFFSET = "zOffset";
    private static final String TAG_X_ORIGIN = "xOrigin";
    private static final String TAG_Y_ORIGIN = "yOrigin";
    private static final String TAG_Z_ORIGIN = "zOrigin";

    public ItemLokiRing(Item.Properties props) {
        super(props);
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getEntityPlayer();
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.func_190926_b() || !player.func_70093_af()) {
            return;
        }
        ItemStack heldItemStack = event.getItemStack();
        BlockPos originCoords = ItemLokiRing.getOriginPos(lokiRing);
        BlockRayTraceResult lookPos = ToolCommons.raytraceFromEntity(player.field_70170_p, player, RayTraceContext.FluidMode.ANY, 10.0);
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        int cost = Math.min(cursors.size(), (int)Math.pow(Math.E, (double)cursors.size() * 0.25));
        if (lookPos.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos hit = lookPos.func_216350_a();
        if (heldItemStack.func_190926_b()) {
            block11: {
                if (!event.getWorld().field_72995_K) {
                    if (originCoords.func_177956_o() == -1) {
                        ItemLokiRing.setOriginPos(lokiRing, hit);
                        ItemLokiRing.setCursorList(lokiRing, null);
                    } else if (originCoords.equals((Object)hit)) {
                        ItemLokiRing.setOriginPos(lokiRing, new BlockPos(0, -1, 0));
                    } else {
                        BlockPos relPos = hit.func_177973_b((Vec3i)originCoords);
                        for (BlockPos cursor : cursors) {
                            if (!cursor.equals((Object)relPos)) continue;
                            cursors.remove(cursor);
                            ItemLokiRing.setCursorList(lokiRing, cursors);
                            break block11;
                        }
                        ItemLokiRing.addCursor(lokiRing, relPos);
                    }
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        } else {
            for (BlockPos cursor : cursors) {
                BlockPos pos = hit.func_177971_a((Vec3i)cursor);
                if (!player.field_70170_p.func_175623_d(pos) || !ManaItemHandler.requestManaExact(lokiRing, player, cost, true)) continue;
                ItemStack saveHeld = heldItemStack.func_77946_l();
                BlockRayTraceResult newHit = new BlockRayTraceResult(lookPos.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), lookPos.func_216354_b(), pos, false);
                heldItemStack.func_196084_a(new ItemUseContext(player, event.getHand(), newHit));
                if (!player.func_184812_l_()) continue;
                player.func_184611_a(event.getHand(), saveHeld);
            }
        }
    }

    public static void breakOnAllCursors(PlayerEntity player, Item item, ItemStack stack, BlockPos pos, Direction side) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.func_190926_b() || player.field_70170_p.field_72995_K || !(item instanceof ISequentialBreaker)) {
            return;
        }
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        ISequentialBreaker breaker = (ISequentialBreaker)item;
        boolean dispose = breaker.disposeOfTrashBlocks(stack);
        for (BlockPos offset : cursors) {
            BlockPos coords = pos.func_177971_a((Vec3i)offset);
            BlockState state = player.field_70170_p.func_180495_p(coords);
            breaker.breakOtherBlock(player, stack, coords, pos, side);
            ToolCommons.removeBlockWithDrops(player, stack, player.field_70170_p, coords, s -> s.func_177230_c() == state.func_177230_c() && s.func_185904_a() == state.func_185904_a(), dispose);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity living) {
        ItemLokiRing.setCursorList(stack, null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BlockPos> getWireframesToDraw(PlayerEntity player, ItemStack stack) {
        if (ItemLokiRing.getLokiRing(player) != stack) {
            return ImmutableList.of();
        }
        RayTraceResult lookPos = Minecraft.func_71410_x().field_71476_x;
        if (lookPos != null && lookPos.func_216346_c() == RayTraceResult.Type.BLOCK && !player.field_70170_p.func_175623_d(((BlockRayTraceResult)lookPos).func_216350_a())) {
            List<BlockPos> list = ItemLokiRing.getCursorList(stack);
            BlockPos origin = ItemLokiRing.getOriginPos(stack);
            for (int i = 0; i < list.size(); ++i) {
                if (origin.func_177956_o() != -1) {
                    list.set(i, list.get(i).func_177971_a((Vec3i)origin));
                    continue;
                }
                list.set(i, list.get(i).func_177971_a((Vec3i)((BlockRayTraceResult)lookPos).func_216350_a()));
            }
            return list;
        }
        return ImmutableList.of();
    }

    @Override
    public BlockPos getSourceWireframe(PlayerEntity player, ItemStack stack) {
        return ItemLokiRing.getLokiRing(player) == stack ? ItemLokiRing.getOriginPos(stack) : null;
    }

    private static ItemStack getLokiRing(PlayerEntity player) {
        return EquipmentHandler.findOrEmpty(ModItems.lokiRing, (LivingEntity)player);
    }

    private static BlockPos getOriginPos(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
        return new BlockPos(x, y, z);
    }

    private static void setOriginPos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, pos.func_177952_p());
    }

    private static List<BlockPos> getCursorList(ItemStack stack) {
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        ArrayList<BlockPos> cursors = new ArrayList<BlockPos>();
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            CompoundNBT cursorCmp = cmp.func_74775_l(TAG_CURSOR_PREFIX + i);
            int x = cursorCmp.func_74762_e(TAG_X_OFFSET);
            int y = cursorCmp.func_74762_e(TAG_Y_OFFSET);
            int z = cursorCmp.func_74762_e(TAG_Z_OFFSET);
            cursors.add(new BlockPos(x, y, z));
        }
        return cursors;
    }

    private static void setCursorList(ItemStack stack, List<BlockPos> cursors) {
        if (stack == null) {
            return;
        }
        CompoundNBT cmp = new CompoundNBT();
        if (cursors != null) {
            int i = 0;
            for (BlockPos cursor : cursors) {
                CompoundNBT cursorCmp = ItemLokiRing.cursorToCmp(cursor);
                cmp.func_218657_a(TAG_CURSOR_PREFIX + i, (INBT)cursorCmp);
                ++i;
            }
            cmp.func_74768_a(TAG_CURSOR_COUNT, i);
        }
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    private static CompoundNBT cursorToCmp(BlockPos pos) {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_74768_a(TAG_X_OFFSET, pos.func_177958_n());
        cmp.func_74768_a(TAG_Y_OFFSET, pos.func_177956_o());
        cmp.func_74768_a(TAG_Z_OFFSET, pos.func_177952_p());
        return cmp;
    }

    private static void addCursor(ItemStack stack, BlockPos pos) {
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        cmp.func_218657_a(TAG_CURSOR_PREFIX + count, (INBT)ItemLokiRing.cursorToCmp(pos));
        cmp.func_74768_a(TAG_CURSOR_COUNT, count + 1);
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/loki_ring");
    }
}

