/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class ItemFlugelEye
extends ItemRelic
implements ICoordBoundItem,
IManaUsingItem {
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_DIMENSION = "dim";

    public ItemFlugelEye(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        if (player != null && player.func_70093_af()) {
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    float x1 = (float)((double)pos.func_177958_n() + Math.random());
                    float y1 = pos.func_177956_o() + 1;
                    float z1 = (float)((double)pos.func_177952_p() + Math.random());
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.5f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                    world.func_195594_a((IParticleData)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(-(-0.05f + (float)Math.random() * 0.05f)), 0.0);
                }
            } else {
                ItemStack stack = ctx.func_195996_i();
                ItemNBTHelper.setInt(stack, TAG_X, pos.func_177958_n());
                ItemNBTHelper.setInt(stack, TAG_Y, pos.func_177956_o());
                ItemNBTHelper.setInt(stack, TAG_Z, pos.func_177952_p());
                ItemNBTHelper.setString(stack, TAG_DIMENSION, world.func_201675_m().func_186058_p().toString());
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 5.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        float x = (float)(living.field_70165_t - Math.random() * (double)living.func_213311_cf());
        float y = (float)(living.field_70163_u + Math.random());
        float z = (float)(living.field_70161_v - Math.random() * (double)living.func_213311_cf());
        WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.7f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
        living.field_70170_p.func_195594_a((IParticleData)data, (double)x, (double)y, (double)z, 0.0, (double)(0.05f + (float)Math.random() * 0.05f), 0.0);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, LivingEntity living) {
        if (!(living instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)living;
        int x = ItemNBTHelper.getInt(stack, TAG_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z, 0);
        DimensionType dim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(ItemNBTHelper.getString(stack, TAG_DIMENSION, "minecraft:overworld")));
        int cost = (int)(MathHelper.pointDistanceSpace((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, player.field_70165_t, player.field_70163_u, player.field_70161_v) * 10.0f);
        if (y > -1 && dim == world.func_201675_m().func_186058_p() && ManaItemHandler.requestManaExact(stack, player, cost, true)) {
            ItemFlugelEye.moveParticlesAndSound((Entity)player);
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147364_a((double)x + 0.5, (double)y + 1.6, (double)z + 0.5, player.field_70177_z, player.field_70125_A);
            }
            ItemFlugelEye.moveParticlesAndSound((Entity)player);
        }
        return stack;
    }

    private static void moveParticlesAndSound(Entity entity) {
        PacketHandler.sendToNearby(entity.field_70170_p, entity, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.FLUGEL_EFFECT, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.func_145782_y()));
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 40;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack par1ItemStack) {
        return UseAction.BOW;
    }

    @Override
    public BlockPos getBinding(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z, 0);
        return y == -1 ? null : new BlockPos(x, y, z);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/flugel_eye");
    }
}

