/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelAxe
extends AxeItem
implements IManaUsingItem,
ISortableTool {
    private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelAxe(Item.Properties props) {
        this(BotaniaAPI.MANASTEEL_ITEM_TIER, props);
    }

    public ItemManasteelAxe(IItemTier mat, Item.Properties props) {
        super(mat, 8.0f, -3.1f, props);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, LivingEntity par2EntityLivingBase, @Nonnull LivingEntity par3EntityLivingBase) {
        ToolCommons.damageItem(par1ItemStack, 1, par3EntityLivingBase, this.getManaPerDamage());
        return true;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        if (state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            ToolCommons.damageItem(stack, 1, entity, this.getManaPerDamage());
        }
        return true;
    }

    public int getManaPerDamage() {
        return 60;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt = player.field_71071_by.func_70301_a(i);
                if (stackAt.func_190926_b() || !SAPLING_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
                ItemStack displayStack = stackAt.func_77946_l();
                ActionResultType did = PlayerHelper.substituteUse(ctx, stackAt);
                ItemsRemainingRenderHandler.set(player, displayStack, SAPLING_PATTERN);
                return did;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof PlayerEntity && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (PlayerEntity)player, this.getManaPerDamage() * 2, true)) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ISortableTool.ToolType getSortingType(ItemStack stack) {
        return ISortableTool.ToolType.AXE;
    }

    @Override
    public int getSortingPriority(ItemStack stack) {
        return ToolCommons.getToolPriority(stack);
    }
}

