/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemSwapRing
extends ItemBauble {
    public ItemSwapRing(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        ItemStack currentStack = player.func_184614_ca();
        if (currentStack.func_190926_b() || !(currentStack.func_77973_b() instanceof ISortableTool)) {
            return;
        }
        ISortableTool tool = (ISortableTool)currentStack.func_77973_b();
        BlockRayTraceResult pos = ToolCommons.raytraceFromEntity(player.field_70170_p, player, RayTraceContext.FluidMode.SOURCE_ONLY, 4.5);
        ISortableTool.ToolType typeToFind = null;
        if (player.field_82175_bq && pos.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockState state = entity.field_70170_p.func_180495_p(pos.func_216350_a());
            Material mat = state.func_185904_a();
            if (ToolCommons.materialsPick.contains(mat)) {
                typeToFind = ISortableTool.ToolType.PICK;
            } else if (ToolCommons.materialsShovel.contains(mat)) {
                typeToFind = ISortableTool.ToolType.SHOVEL;
            } else if (ToolCommons.materialsAxe.contains(mat)) {
                typeToFind = ISortableTool.ToolType.AXE;
            }
        }
        if (typeToFind == null) {
            return;
        }
        ItemStack bestTool = currentStack;
        int bestToolPriority = tool.getSortingType(currentStack) == typeToFind ? tool.getSortingPriority(currentStack) : -1;
        int bestSlot = -1;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            int priority;
            ISortableTool toolInSlot;
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof ISortableTool) || stackInSlot == currentStack || !(toolInSlot = (ISortableTool)stackInSlot.func_77973_b()).getSortingType(stackInSlot).equals((Object)typeToFind) || (priority = toolInSlot.getSortingPriority(stackInSlot)) <= bestToolPriority) continue;
            bestTool = stackInSlot;
            bestToolPriority = priority;
            bestSlot = i;
        }
        if (bestSlot != -1) {
            player.func_184611_a(Hand.MAIN_HAND, bestTool);
            player.field_71071_by.func_70299_a(bestSlot, currentStack);
        }
    }
}

