/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemItemFinder
extends ItemBauble {
    private static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
    private static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";

    public ItemItemFinder(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        if (!(player instanceof PlayerEntity)) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            this.tickClient(stack, (PlayerEntity)player);
        } else {
            this.tickServer(stack, (PlayerEntity)player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        TextureAtlasSprite gemIcon = MiscellaneousIcons.INSTANCE.itemFinderGem;
        float f = gemIcon.func_94209_e();
        float f1 = gemIcon.func_94212_f();
        float f2 = gemIcon.func_94206_g();
        float f3 = gemIcon.func_94210_h();
        boolean armor = !living.func_184582_a(EquipmentSlotType.HEAD).func_190926_b();
        AccessoryRenderHelper.translateToHeadLevel(living);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.4f, (float)-1.4f, (float)(armor ? -0.3f : -0.25f));
        GlStateManager.scalef((float)0.75f, (float)0.75f, (float)0.75f);
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, gemIcon.func_94211_a(), gemIcon.func_94216_b(), 0.0625f);
    }

    protected void tickClient(ItemStack stack, PlayerEntity player) {
        int[] entities;
        if (!Botania.proxy.isTheClientPlayer((LivingEntity)player)) {
            return;
        }
        ListNBT blocks = ItemNBTHelper.getList(stack, TAG_BLOCK_POSITIONS, 4, false);
        for (int i = 0; i < blocks.size(); ++i) {
            BlockPos pos = BlockPos.func_218283_e((long)((LongNBT)blocks.get(i)).func_150291_c());
            float m = 0.02f;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), false);
            player.field_70170_p.func_195594_a((IParticleData)data, (double)((float)pos.func_177958_n() + (float)Math.random()), (double)((float)pos.func_177956_o() + (float)Math.random()), (double)((float)pos.func_177952_p() + (float)Math.random()), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)));
        }
        for (int i : entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS)) {
            Entity e = player.field_70170_p.func_73045_a(i);
            if (e == null || !(Math.random() < 0.6)) continue;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), Math.random() < 0.6);
            player.field_70170_p.func_195594_a((IParticleData)data, e.field_70165_t + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.field_70163_u + (double)e.func_213302_cg(), e.field_70161_v + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), 0.0, (double)(0.05f + 0.03f * (float)Math.random()), 0.0);
        }
    }

    protected void tickServer(ItemStack stack, PlayerEntity player) {
        IntArrayList entPosBuilder = new IntArrayList();
        ListNBT blockPosBuilder = new ListNBT();
        this.scanForStack(player.func_184614_ca(), player, entPosBuilder, blockPosBuilder);
        this.scanForStack(player.func_184592_cb(), player, entPosBuilder, blockPosBuilder);
        int[] currentEnts = entPosBuilder.elements();
        ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, currentEnts);
        ItemNBTHelper.setList(stack, TAG_BLOCK_POSITIONS, blockPosBuilder);
    }

    private void scanForStack(ItemStack pstack, PlayerEntity player, IntArrayList entIdBuilder, ListNBT blockPosBuilder) {
        if (!pstack.func_190926_b() || player.func_70093_af()) {
            int range = 24;
            List entities = player.field_70170_p.func_217357_a(Entity.class, new AxisAlignedBB(player.field_70165_t - (double)range, player.field_70163_u - (double)range, player.field_70161_v - (double)range, player.field_70165_t + (double)range, player.field_70163_u + (double)range, player.field_70161_v + (double)range));
            for (Entity e : entities) {
                if (e == player) continue;
                if (e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && !(e instanceof PlayerEntity)) {
                    if (!this.scanInventory((LazyOptional<? extends IItemHandler>)e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY), pstack)) continue;
                    entIdBuilder.add(e.func_145782_y());
                    continue;
                }
                if (e instanceof ItemEntity) {
                    ItemEntity item = (ItemEntity)e;
                    ItemStack istack = item.func_92059_d();
                    if (!player.func_70093_af() && (!istack.func_77969_a(pstack) || !ItemStack.func_77970_a((ItemStack)istack, (ItemStack)pstack))) continue;
                    entIdBuilder.add(item.func_145782_y());
                    continue;
                }
                if (e instanceof IInventory) {
                    IInventory inv = (IInventory)e;
                    if (!this.scanInventory((LazyOptional<? extends IItemHandler>)LazyOptional.of(() -> new InvWrapper(inv)), pstack)) continue;
                    entIdBuilder.add(e.func_145782_y());
                    continue;
                }
                if (e instanceof PlayerEntity) {
                    PlayerEntity player_ = (PlayerEntity)e;
                    LazyOptional playerInv = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                    LazyOptional<IItemHandlerModifiable> binv = EquipmentHandler.getAllWorn((LivingEntity)player);
                    if (!this.scanInventory((LazyOptional<? extends IItemHandler>)playerInv, pstack) && !this.scanInventory(binv, pstack)) continue;
                    entIdBuilder.add(player_.func_145782_y());
                    continue;
                }
                if (!(e instanceof VillagerEntity)) continue;
                VillagerEntity villager = (VillagerEntity)e;
                for (MerchantOffer offer : villager.func_213706_dY()) {
                    if (!this.equalStacks(pstack, offer.func_222218_a()) && !this.equalStacks(pstack, offer.func_222202_c()) && !this.equalStacks(pstack, offer.func_222200_d())) continue;
                    entIdBuilder.add(villager.func_145782_y());
                }
            }
            if (!pstack.func_190926_b()) {
                range = 12;
                BlockPos pos = new BlockPos((Entity)player);
                for (BlockPos pos_ : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range + 1, range + 1, range + 1))) {
                    IInventory inv;
                    TileEntity tile = player.field_70170_p.func_175625_s(pos_);
                    if (tile == null) continue;
                    boolean foundCap = false;
                    for (Direction e : Direction.values()) {
                        if (!this.scanInventory((LazyOptional<? extends IItemHandler>)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e), pstack)) continue;
                        blockPosBuilder.add((Object)new LongNBT(pos_.func_218275_a()));
                        foundCap = true;
                        break;
                    }
                    if (foundCap || !(tile instanceof IInventory) || !this.scanInventory((LazyOptional<? extends IItemHandler>)LazyOptional.of(() -> ItemItemFinder.lambda$scanForStack$1(inv = (IInventory)tile)), pstack)) continue;
                    blockPosBuilder.add((Object)new LongNBT(pos_.func_218275_a()));
                }
            }
        }
    }

    private boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private boolean scanInventory(LazyOptional<? extends IItemHandler> optInv, ItemStack pstack) {
        return (Boolean)optInv.map(inv -> this.scanInventory((IItemHandler)inv, pstack)).orElse((Object)false);
    }

    private boolean scanInventory(IItemHandler inv, ItemStack pstack) {
        if (pstack.func_190926_b()) {
            return false;
        }
        for (int l = 0; l < inv.getSlots(); ++l) {
            ItemStack istack = inv.getStackInSlot(l);
            if (istack.func_190926_b() || !this.equalStacks(istack, pstack)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ InvWrapper lambda$scanForStack$1(IInventory inv) {
        return new InvWrapper(inv);
    }
}

