/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

@Mod.EventBusSubscriber(modid="botania")
public class ItemGoddessCharm
extends ItemBauble
implements IManaUsingItem {
    public static final int COST = 1000;

    public ItemGoddessCharm(Item.Properties props) {
        super(props);
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Explosion e = event.getExplosion();
        Vec3d vec = e.getPosition();
        List players = event.getWorld().func_217357_a(PlayerEntity.class, new AxisAlignedBB(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c).func_186662_g(8.0));
        for (PlayerEntity player : players) {
            ItemStack charm = EquipmentHandler.findOrEmpty(ModItems.goddessCharm, (LivingEntity)player);
            if (charm.func_190926_b() || !ManaItemHandler.requestManaExact(charm, player, 1000, true)) continue;
            event.getAffectedBlocks().clear();
            return;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        AccessoryRenderHelper.translateToHeadLevel(player);
        AccessoryRenderHelper.translateToFace();
        AccessoryRenderHelper.defaultTransforms();
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.5f, (float)0.2f, (float)0.45f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.popMatrix();
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

