/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemIncenseStick
extends ItemMod
implements IBrewItem,
IBrewContainer {
    private static final String TAG_BREW_KEY = "brewKey";
    public static final int TIME_MULTIPLIER = 60;

    public ItemIncenseStick(Item.Properties builder) {
        super(builder);
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack brewStack = this.getItemForBrew(BotaniaAPI.brewMap.get(s), new ItemStack((IItemProvider)this));
                if (brewStack.func_190926_b()) continue;
                list.add((Object)brewStack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        Brew brew = this.getBrew(stack);
        if (brew == BotaniaAPI.fallbackBrew) {
            list.add(new TranslationTextComponent("botaniamisc.notInfused", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
            return;
        }
        list.add(new TranslationTextComponent("botaniamisc.brewOf", new Object[]{new TranslationTextComponent(brew.getUnlocalizedName(stack), new Object[0])}).func_211708_a(TextFormatting.LIGHT_PURPLE));
        for (EffectInstance effect : brew.getPotionEffects(stack)) {
            TextFormatting format = !effect.func_188419_a().func_188408_i() ? TextFormatting.RED : TextFormatting.GRAY;
            EffectInstance longEffect = new EffectInstance(effect.func_188419_a(), effect.func_76459_b() * 60, effect.func_76458_c(), false, true);
            TranslationTextComponent cmp = new TranslationTextComponent(effect.func_76453_d(), new Object[0]);
            if (effect.func_76458_c() > 0) {
                cmp.func_150258_a(" ");
                cmp.func_150257_a((ITextComponent)new TranslationTextComponent("botania.roman" + (effect.func_76458_c() + 1), new Object[0]));
            }
            if (!effect.func_188419_a().func_76403_b()) {
                cmp.func_150257_a(new StringTextComponent(" (" + EffectUtils.func_188410_a((EffectInstance)longEffect, (float)1.0f) + ")").func_211708_a(TextFormatting.GRAY));
            }
            list.add(cmp.func_211708_a(format));
        }
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return BotaniaAPI.getBrewFromKey(key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemIncenseStick.setBrew(stack, brew.getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew);
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseIncense() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).func_188419_a().func_76403_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack brewStack = new ItemStack((IItemProvider)this);
        ItemIncenseStick.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }
}

