/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityThrowableCopy
extends Entity
implements IProjectile {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    protected boolean inGround;
    public int throwableShake;
    protected LivingEntity owner;
    private UUID ownerId;
    private Entity ignoreEntity;
    private int ignoreTime;

    protected EntityThrowableCopy(EntityType<? extends EntityThrowableCopy> type, World worldIn) {
        super(type, worldIn);
    }

    protected EntityThrowableCopy(EntityType<? extends EntityThrowableCopy> type, double x, double y, double z, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected EntityThrowableCopy(EntityType<? extends EntityThrowableCopy> type, LivingEntity livingEntityIn, World worldIn) {
        this(type, livingEntityIn.field_70165_t, livingEntityIn.field_70163_u + (double)livingEntityIn.func_70047_e() - (double)0.1f, livingEntityIn.field_70161_v, worldIn);
        this.owner = livingEntityIn;
        this.ownerId = livingEntityIn.func_110124_au();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vec3d vec3d = entityThrower.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, entityThrower.field_70122_E ? 0.0 : vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)EntityThrowableCopy.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70071_h_() {
        float f1;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            this.inGround = false;
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, axisalignedbb, p_213881_0_ -> !p_213881_0_.func_175149_v() && p_213881_0_.func_70067_L())) {
            if (entity == this.ignoreEntity) {
                ++this.ignoreTime;
                break;
            }
            if (this.owner == null || this.field_70173_aa >= 2 || this.ignoreEntity != null) continue;
            this.ignoreEntity = entity;
            this.ignoreTime = 3;
            break;
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)axisalignedbb, p_213880_1_ -> !p_213880_1_.func_175149_v() && p_213880_1_.func_70067_L() && p_213880_1_ != this.ignoreEntity, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (this.ignoreEntity != null && this.ignoreTime-- <= 0) {
            this.ignoreEntity = null;
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)raytraceresult).func_216350_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(((BlockRayTraceResult)raytraceresult).func_216350_a());
            } else if (!ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onImpact(raytraceresult);
            }
        }
        Vec3d vec3d = this.func_213322_ci();
        this.field_70165_t += vec3d.field_72450_a;
        this.field_70163_u += vec3d.field_72448_b;
        this.field_70161_v += vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)EntityThrowableCopy.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f2 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t - vec3d.field_72450_a * 0.25, this.field_70163_u - vec3d.field_72448_b * 0.25, this.field_70161_v - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            f1 = 0.8f;
        } else {
            f1 = 0.99f;
        }
        this.func_213317_d(vec3d.func_186678_a((double)f1));
        if (!this.func_189652_ae()) {
            Vec3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.getGravityVelocity(), vec3d1.field_72449_c);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected abstract void onImpact(RayTraceResult var1);

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74774_a("shake", (byte)this.throwableShake);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if (this.ownerId != null) {
            compound.func_218657_a("owner", (INBT)NBTUtil.func_186862_a((UUID)this.ownerId));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.throwableShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74771_c("inGround") == 1;
        this.owner = null;
        if (compound.func_150297_b("owner", 10)) {
            this.ownerId = NBTUtil.func_186860_b((CompoundNBT)compound.func_74775_l("owner"));
        }
    }

    @Nullable
    public LivingEntity getThrower() {
        if (this.owner == null && this.ownerId != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerId);
            if (entity instanceof LivingEntity) {
                this.owner = (LivingEntity)entity;
            } else {
                this.ownerId = null;
            }
        }
        return this.owner;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

