/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

public class TerraPickTippingRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<TerraPickTippingRecipe> SERIALIZER = new SpecialRecipeSerializer(TerraPickTippingRecipe::new);

    public TerraPickTippingRecipe(ResourceLocation id) {
        super(id);
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundTerraPick = false;
        boolean foundElementiumPick = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemTerraPick && !ItemTerraPick.isTipped(stack)) {
                foundTerraPick = true;
                continue;
            }
            if (stack.func_77973_b() == ModItems.elementiumPick) {
                foundElementiumPick = true;
                continue;
            }
            return false;
        }
        return foundTerraPick && foundElementiumPick;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack terraPick = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemTerraPick)) continue;
            terraPick = stack;
        }
        if (terraPick.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack terraPickCopy = terraPick.func_77946_l();
        ItemTerraPick.setTipped(terraPickCopy);
        return terraPickCopy;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }
}

