/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public final class ItemNBTHelper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        stack.func_196082_o().func_74757_a(tag, b);
    }

    public static void setByte(ItemStack stack, String tag, byte b) {
        stack.func_196082_o().func_74774_a(tag, b);
    }

    public static void setShort(ItemStack stack, String tag, short s) {
        stack.func_196082_o().func_74777_a(tag, s);
    }

    public static void setInt(ItemStack stack, String tag, int i) {
        stack.func_196082_o().func_74768_a(tag, i);
    }

    public static void setIntArray(ItemStack stack, String tag, int[] val) {
        stack.func_196082_o().func_74783_a(tag, val);
    }

    public static void setLong(ItemStack stack, String tag, long l) {
        stack.func_196082_o().func_74772_a(tag, l);
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        stack.func_196082_o().func_74776_a(tag, f);
    }

    public static void setDouble(ItemStack stack, String tag, double d) {
        stack.func_196082_o().func_74780_a(tag, d);
    }

    public static void setCompound(ItemStack stack, String tag, CompoundNBT cmp) {
        if (!tag.equalsIgnoreCase("ench")) {
            stack.func_196082_o().func_218657_a(tag, (INBT)cmp);
        }
    }

    public static void setString(ItemStack stack, String tag, String s) {
        stack.func_196082_o().func_74778_a(tag, s);
    }

    public static void setUuid(ItemStack stack, String tag, UUID value) {
        stack.func_196082_o().func_186854_a(tag, value);
    }

    public static void setList(ItemStack stack, String tag, ListNBT list) {
        stack.func_196082_o().func_218657_a(tag, (INBT)list);
    }

    public static void removeEntry(ItemStack stack, String tag) {
        stack.func_196082_o().func_82580_o(tag);
    }

    public static boolean verifyExistance(ItemStack stack, String tag) {
        return !stack.func_190926_b() && stack.func_196082_o().func_74764_b(tag);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74767_n(tag) : defaultExpected;
    }

    public static byte getByte(ItemStack stack, String tag, byte defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74771_c(tag) : defaultExpected;
    }

    public static short getShort(ItemStack stack, String tag, short defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74765_d(tag) : defaultExpected;
    }

    public static int getInt(ItemStack stack, String tag, int defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74762_e(tag) : defaultExpected;
    }

    public static int[] getIntArray(ItemStack stack, String tag) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74759_k(tag) : EMPTY_INT_ARRAY;
    }

    public static long getLong(ItemStack stack, String tag, long defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74763_f(tag) : defaultExpected;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74760_g(tag) : defaultExpected;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74769_h(tag) : defaultExpected;
    }

    public static CompoundNBT getCompound(ItemStack stack, String tag, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74775_l(tag) : (nullifyOnFail ? null : new CompoundNBT());
    }

    public static String getString(ItemStack stack, String tag, String defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_74779_i(tag) : defaultExpected;
    }

    @Nullable
    public static UUID getUuid(ItemStack stack, String tag) {
        return ItemNBTHelper.verifyExistance(stack, tag + "Most") && ItemNBTHelper.verifyExistance(stack, tag + "Least") ? stack.func_196082_o().func_186857_a(tag) : null;
    }

    public static ListNBT getList(ItemStack stack, String tag, int objtype, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.func_196082_o().func_150295_c(tag, objtype) : (nullifyOnFail ? null : new ListNBT());
    }

    public static boolean matchTag(@Nullable INBT template, @Nullable INBT target) {
        if (template instanceof CompoundNBT && target instanceof CompoundNBT) {
            return ItemNBTHelper.matchTagCompound((CompoundNBT)template, (CompoundNBT)target);
        }
        if (template instanceof ListNBT && target instanceof ListNBT) {
            return ItemNBTHelper.matchTagList((ListNBT)template, (ListNBT)target);
        }
        return template == null || target != null && target.equals(template);
    }

    private static boolean matchTagCompound(CompoundNBT template, CompoundNBT target) {
        if (template.func_186856_d() > target.func_186856_d()) {
            return false;
        }
        for (String key : template.func_150296_c()) {
            if (ItemNBTHelper.matchTag(template.func_74781_a(key), target.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTagList(ListNBT template, ListNBT target) {
        if (template.size() > target.size()) {
            return false;
        }
        for (int i = 0; i < template.size(); ++i) {
            if (ItemNBTHelper.matchTag(template.get(i), target.get(i))) continue;
            return false;
        }
        return true;
    }
}

