/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPixieSpawner;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumHelm;

@Mod.EventBusSubscriber(modid="botania")
public final class PixieHandler {
    private static final Effect[] potions = new Effect[]{Effects.field_76440_q, Effects.field_82731_v, Effects.field_76421_d, Effects.field_76437_t};

    private PixieHandler() {
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof PlayerEntity && event.getSource().func_76346_g() instanceof LivingEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = PlayerHelper.getFirstHeldItemClass(player, IPixieSpawner.class);
            float chance = PixieHandler.getChance(stack);
            for (ItemStack element : player.field_71071_by.field_70460_b) {
                chance += PixieHandler.getChance(element);
            }
            IItemHandlerModifiable handler = BotaniaAPI.internalHandler.getAccessoriesInventory(player);
            for (int i = 0; i < handler.getSlots(); ++i) {
                chance += PixieHandler.getChance(handler.getStackInSlot(i));
            }
            if (Math.random() < (double)chance) {
                EntityPixie pixie = new EntityPixie(player.field_70170_p);
                pixie.func_70107_b(player.field_70165_t, player.field_70163_u + 2.0, player.field_70161_v);
                if (((ItemElementiumHelm)ModItems.elementiumHelm).hasArmorSet(player)) {
                    pixie.setApplyPotionEffect(new EffectInstance(potions[event.getEntityLiving().field_70170_p.field_73012_v.nextInt(potions.length)], 40, 0));
                }
                float dmg = 4.0f;
                if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.elementiumSword) {
                    dmg += 2.0f;
                }
                pixie.setProps((LivingEntity)event.getSource().func_76346_g(), (LivingEntity)player, 0, dmg);
                pixie.func_213386_a((IWorld)player.field_70170_p, player.field_70170_p.func_175649_E(new BlockPos((Entity)pixie)), SpawnReason.EVENT, null, null);
                player.field_70170_p.func_217376_c((Entity)pixie);
            }
        }
    }

    private static float getChance(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPixieSpawner)) {
            return 0.0f;
        }
        return ((IPixieSpawner)stack.func_77973_b()).getPixieChance(stack);
    }
}

