/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.string;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.common.block.tile.string.TileRedString;

public class TileRedStringContainer
extends TileRedString {
    @ObjectHolder(value="botania:red_string_container")
    public static TileEntityType<TileRedStringContainer> TYPE;
    private static final LazyOptional<IItemHandler> EMPTY;
    @Nullable
    private LazyOptional<?> lastBoundInv = null;

    public TileRedStringContainer() {
        this(TYPE);
    }

    public TileRedStringContainer(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public boolean acceptBlock(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        return tile != null && Arrays.stream(Direction.values()).anyMatch(e -> tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e).isPresent());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.getTileAtBinding() != null) {
                this.lastBoundInv = this.getTileAtBinding().getCapability(cap, side);
                return this.lastBoundInv.cast();
            }
            this.invalidateLastCap();
            return EMPTY.cast();
        }
        return super.getCapability(cap, side);
    }

    private void invalidateLastCap() {
        if (this.lastBoundInv != null) {
            this.lastBoundInv.invalidate();
            this.lastBoundInv = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateLastCap();
    }

    public void func_70296_d() {
        super.func_70296_d();
        TileEntity tile = this.getTileAtBinding();
        if (tile != null) {
            tile.func_70296_d();
        }
    }

    static {
        EMPTY = LazyOptional.of(EmptyHandler::new);
    }
}

