/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.client.fx.WispParticleData;

public class SubTileHydroangeas
extends TileEntityGeneratingFlower {
    @ObjectHolder(value="botania:hydroangeas")
    public static TileEntityType<SubTileHydroangeas> TYPE;
    private static final String TAG_BURN_TIME = "burnTime";
    public static final String TAG_COOLDOWN = "cooldown";
    private static final BlockPos[] OFFSETS;
    int burnTime;
    int cooldown;

    public SubTileHydroangeas() {
        this(TYPE);
    }

    public SubTileHydroangeas(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.cooldown > 0) {
            --this.cooldown;
            for (int i = 0; i < 3; ++i) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.1f, 0.1f, 0.1f, 1.0f);
                this.field_145850_b.func_195594_a((IParticleData)data, (double)this.func_174877_v().func_177958_n() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.func_174877_v().func_177956_o() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.func_174877_v().func_177952_p() + 0.5 + Math.random() * 0.2 - 0.1, 0.0, (double)((float)Math.random() / 30.0f), 0.0);
            }
        }
        if (this.burnTime == 0) {
            if (this.getMana() < this.getMaxMana() && !this.func_145831_w().field_72995_K) {
                List<BlockPos> offsets = Arrays.asList(OFFSETS);
                Collections.shuffle(offsets);
                for (BlockPos offset : offsets) {
                    Tag<Fluid> search;
                    BlockPos pos = this.func_174877_v().func_177971_a((Vec3i)offset);
                    IFluidState fstate = this.func_145831_w().func_204610_c(pos);
                    if (!fstate.func_206884_a(search = this.getMaterialToSearchFor()) || this.getBlockToSearchBelow() != null && this.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() != this.getBlockToSearchBelow() || !fstate.func_206889_d()) continue;
                    if (search != FluidTags.field_206959_a) {
                        this.func_145831_w().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    } else {
                        int waterAround = 0;
                        for (Direction dir : Direction.values()) {
                            if (!this.func_145831_w().func_204610_c(pos.func_177972_a(dir)).func_206884_a(search)) continue;
                            ++waterAround;
                        }
                        if (waterAround < 2) {
                            this.func_145831_w().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        }
                    }
                    if (this.cooldown == 0) {
                        this.burnTime += this.getBurnTime();
                    } else {
                        this.cooldown = this.getCooldown();
                    }
                    this.sync();
                    this.playSound();
                    break;
                }
            }
        } else {
            if (this.func_145831_w().field_73012_v.nextInt(8) == 0) {
                this.doBurnParticles();
            }
            --this.burnTime;
            if (this.burnTime == 0) {
                this.cooldown = this.getCooldown();
                this.sync();
            }
        }
    }

    public void doBurnParticles() {
        WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.05f, 0.05f, 0.7f, 1.0f);
        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.func_174877_v().func_177958_n() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.func_174877_v().func_177956_o() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, (double)((float)Math.random() / 60.0f), 0.0);
    }

    public Tag<Fluid> getMaterialToSearchFor() {
        return FluidTags.field_206959_a;
    }

    public Block getBlockToSearchBelow() {
        return null;
    }

    public void playSound() {
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
    }

    public int getBurnTime() {
        return 40;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.func_174877_v(), 1);
    }

    @Override
    public int getMaxMana() {
        return 150;
    }

    @Override
    public int getColor() {
        return 5451744;
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BURN_TIME, this.burnTime);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.func_74762_e(TAG_BURN_TIME);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
    }

    @Override
    public boolean canGeneratePassively() {
        return this.burnTime > 0;
    }

    @Override
    public int getDelayBetweenPassiveGeneration() {
        boolean rain = this.func_145831_w().func_180494_b(this.func_174877_v()).func_201851_b() == Biome.RainType.RAIN && (this.func_145831_w().func_72896_J() || this.func_145831_w().func_72911_I());
        return rain ? 2 : 3;
    }

    public int getCooldown() {
        return 0;
    }

    @Override
    public boolean isPassiveFlower() {
        return true;
    }

    static {
        OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    }
}

