/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.item.IExoflameHeatable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.Botania;

public class SubTileExoflame
extends TileEntityFunctionalFlower {
    @ObjectHolder(value="botania:exoflame")
    public static TileEntityType<SubTileExoflame> TYPE;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 2;
    private static final int COST = 300;
    private static final Field RECIPE_TYPE;
    private static final Method CAN_SMELT;

    public SubTileExoflame() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean did = false;
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.func_174877_v().func_177982_a(-5, -2, -5), (BlockPos)this.func_174877_v().func_177982_a(5, 2, 5))) {
            IExoflameHeatable heatable;
            TileEntity tile = this.func_145831_w().func_175625_s(pos);
            BlockState state = this.func_145831_w().func_180495_p(pos);
            if (tile instanceof AbstractFurnaceTileEntity) {
                AbstractFurnaceTileEntity furnace = (AbstractFurnaceTileEntity)tile;
                Pair<AbstractCookingRecipe, Boolean> p = SubTileExoflame.canSmelt(furnace);
                if (p == null) continue;
                AbstractCookingRecipe recipe = (AbstractCookingRecipe)p.getFirst();
                boolean canSmelt = (Boolean)p.getSecond();
                if (!canSmelt || this.getMana() <= 2) continue;
                if (furnace.field_214018_j < 2) {
                    if (furnace.field_214018_j == 0) {
                        this.func_145831_w().func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
                    }
                    furnace.field_214018_j = 200;
                    this.addMana(-300);
                }
                if (this.ticksExisted % 2 == 0) {
                    furnace.field_214020_l = Math.min(recipe.func_222137_e() - 1, furnace.field_214020_l + 1);
                }
                did = true;
                if (this.getMana() > 0) continue;
                break;
            }
            if (!(tile instanceof IExoflameHeatable) || !(heatable = (IExoflameHeatable)tile).canSmelt() || this.getMana() <= 2) continue;
            if (heatable.getBurnTime() == 0) {
                heatable.boostBurnTime();
                this.addMana(-300);
            }
            if (this.ticksExisted % 2 == 0) {
                heatable.boostCookTime();
            }
            if (this.getMana() > 0) continue;
            break;
        }
        if (did) {
            this.sync();
        }
    }

    @Nullable
    public static Pair<AbstractCookingRecipe, Boolean> canSmelt(AbstractFurnaceTileEntity furnace) {
        try {
            IRecipeType rt = (IRecipeType)RECIPE_TYPE.get(furnace);
            AbstractCookingRecipe recipe = furnace.func_145831_w().func_199532_z().func_215371_a(rt, (IInventory)furnace, furnace.func_145831_w()).orElse(null);
            boolean canSmelt = (Boolean)CAN_SMELT.invoke((Object)furnace, recipe);
            return Pair.of((Object)recipe, (Object)canSmelt);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Botania.LOGGER.error("Failed to reflect furnace", (Throwable)e);
            return null;
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.func_174877_v(), 5);
    }

    @Override
    public int getMaxMana() {
        return 300;
    }

    @Override
    public int getColor() {
        return 0x661600;
    }

    static {
        RECIPE_TYPE = ObfuscationReflectionHelper.findField(AbstractFurnaceTileEntity.class, (String)"field_214014_c");
        CAN_SMELT = ObfuscationReflectionHelper.findMethod(AbstractFurnaceTileEntity.class, (String)"func_214008_b", (Class[])new Class[]{IRecipe.class});
    }
}

