/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileBrewery;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;

public class BlockBrewery
extends BlockMod
implements IWandHUD {
    private static final VoxelShape SHAPE = BlockBrewery.func_208617_a((double)6.0, (double)0.8, (double)6.0, (double)10.0, (double)15.2, (double)10.0);

    public BlockBrewery(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BotaniaStateProps.POWERED});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileBrewery brew = (TileBrewery)world.func_175625_s(pos);
        if (player.func_70093_af()) {
            if (brew.recipe == null && !((Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED)).booleanValue()) {
                InventoryHelper.withdrawFromInventory(brew, player);
                return true;
            }
        } else {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b()) {
                return brew.addItem(player, stack, hand);
            }
        }
        return false;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileBrewery brew = (TileBrewery)world.func_175625_s(pos);
        return brew.signal;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileBrewery();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        ((TileBrewery)world.func_175625_s(pos)).renderHUD(mc);
    }
}

