/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.capability.FloatingFlowerImpl;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.advancements.AlfPortalTrigger;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.advancements.DopplegangerNoArmorTrigger;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.block.ModBanners;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.command.CommandSkyblockSpread;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.IMCHandler;
import vazkii.botania.common.core.handler.IMCSender;
import vazkii.botania.common.core.handler.InternalMethodHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.loot.BindUuid;
import vazkii.botania.common.core.loot.EnableRelics;
import vazkii.botania.common.core.loot.LootHandler;
import vazkii.botania.common.core.loot.TrueGuardianKiller;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.core.proxy.ServerProxy;
import vazkii.botania.common.crafting.FluxfieldCondition;
import vazkii.botania.common.crafting.SyncHandler;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.world.ModFeatures;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.common.world.WorldTypeSkyblock;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.multiblock.StateMatcher;

@Mod(value="botania")
public class Botania {
    public static boolean gardenOfGlassLoaded = false;
    public static boolean thaumcraftLoaded = false;
    public static boolean bcApiLoaded = false;
    public static boolean bloodMagicLoaded = false;
    public static boolean coloredLightsLoaded = false;
    public static boolean curiosLoaded = false;
    public static Botania instance;
    public static IProxy proxy;
    public static boolean finishedLoading;
    public static final Logger LOGGER;

    public Botania() {
        instance = this;
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        proxy.registerHandlers();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(IMCSender::enqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(IMCHandler::handle);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IFloatingFlower.class, (Capability.IStorage)new IFloatingFlower.Storage(), FloatingFlowerImpl::new);
        gardenOfGlassLoaded = ModList.get().isLoaded("gardenofglass");
        thaumcraftLoaded = ModList.get().isLoaded("thaumcraft");
        bcApiLoaded = ModList.get().isLoaded("buildcraftlib");
        bloodMagicLoaded = ModList.get().isLoaded("bloodmagic");
        coloredLightsLoaded = ModList.get().isLoaded("easycoloredlights");
        curiosLoaded = ModList.get().isLoaded("curios");
        BotaniaAPI.internalHandler = new InternalMethodHandler();
        PacketHandler.init();
        ModBrews.init();
        if (thaumcraftLoaded) {
            if (((Boolean)ConfigHandler.COMMON.enableThaumcraftAspects.get()).booleanValue()) {
                // empty if block
            }
            ModBrews.initTC();
        }
        MinecraftForge.EVENT_BUS.register((Object)ManaNetworkHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)TileCorporeaIndex.getInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        EquipmentHandler.init();
        if (gardenOfGlassLoaded) {
            MinecraftForge.EVENT_BUS.register(SkyblockWorldEvents.class);
        }
        DeferredWorkQueue.runLater(() -> {
            if (gardenOfGlassLoaded) {
                new WorldTypeSkyblock();
            }
            ModBanners.init();
            String[][] pat = new String[][]{{"_", "W", "G", "W", "_"}, {"W", "_", "_", "_", "W"}, {"G", "_", "_", "_", "G"}, {"W", "_", "_", "_", "W"}, {"_", "W", "0", "W", "_"}};
            IMultiblock mb = PatchouliAPI.instance.makeMultiblock(pat, new Object[]{Character.valueOf('W'), ModBlocks.livingwood, Character.valueOf('G'), ModBlocks.livingwoodGlimmering, Character.valueOf('0'), ModBlocks.alfPortal});
            PatchouliAPI.instance.registerMultiblock(ModBlocks.alfPortal.getRegistryName(), mb);
            pat = new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}};
            mb = PatchouliAPI.instance.makeMultiblock(pat, new Object[]{Character.valueOf('P'), ModBlocks.terraPlate, Character.valueOf('R'), ModBlocks.livingrock, Character.valueOf('0'), ModBlocks.livingrock, Character.valueOf('L'), Blocks.field_150368_y});
            PatchouliAPI.instance.registerMultiblock(ModBlocks.terraPlate.getRegistryName(), mb);
            pat = new String[][]{{"_P_______P_", "___________", "___________", "P_________P", "___________", "___________", "_P_______P_"}, {"_F_______F_", "___________", "____F_F____", "F____L____F", "____F_F____", "___________", "_F_______F_"}, {"___________", "____BBB____", "___B_B_B___", "___BB0BB___", "___B_B_B___", "____BBB____", "___________"}};
            mb = PatchouliAPI.instance.makeMultiblock(pat, new Object[]{Character.valueOf('P'), ModBlocks.manaPylon, Character.valueOf('L'), Blocks.field_150368_y, Character.valueOf('B'), Blocks.field_150343_Z, Character.valueOf('0'), Blocks.field_150343_Z, Character.valueOf('F'), StateMatcher.fromPredicate((Block)ModBlocks.whiteFlower, state -> state.func_177230_c().func_203417_a(ModTags.Blocks.MYSTICAL_FLOWERS))});
            PatchouliAPI.instance.registerMultiblock(ModBlocks.enchanter.getRegistryName(), mb);
            pat = new String[][]{{"P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P"}, {"_________", "_________", "_________", "_________", "____B____", "_________", "_________", "_________", "_________"}, {"_________", "_________", "_________", "___III___", "___I0I___", "___III___", "_________", "_________", "_________"}};
            StateMatcher sm = StateMatcher.fromPredicate((Block)Blocks.field_150339_S, state -> {
                try {
                    return state.isBeaconBase(null, null, null);
                }
                catch (Exception ignored) {
                    return false;
                }
            });
            mb = PatchouliAPI.instance.makeMultiblock(pat, new Object[]{Character.valueOf('P'), ModBlocks.gaiaPylon, Character.valueOf('B'), Blocks.field_150461_bJ, Character.valueOf('I'), sm, Character.valueOf('0'), sm});
            PatchouliAPI.instance.registerMultiblock(new ResourceLocation("botania", "gaia_ritual"), mb);
            LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new TrueGuardianKiller.Serializer());
            LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new EnableRelics.Serializer());
            LootFunctionManager.func_186582_a((ILootFunction.Serializer)new BindUuid.Serializer());
            CriteriaTriggers.func_192118_a((ICriterionTrigger)AlfPortalTrigger.INSTANCE);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)CorporeaRequestTrigger.INSTANCE);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)DopplegangerNoArmorTrigger.INSTANCE);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)RelicBindTrigger.INSTANCE);
            CriteriaTriggers.func_192118_a((ICriterionTrigger)UseItemSuccessTrigger.INSTANCE);
            CraftingHelper.register(FluxfieldCondition.SERIALIZER);
            ModBlocks.addDispenserBehaviours();
            ModFeatures.addWorldgen();
        });
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        finishedLoading = true;
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        String expect;
        String clname = BotaniaAPI.internalHandler.getClass().getName();
        if (!clname.equals(expect = "vazkii.botania.common.core.handler.InternalMethodHandler")) {
            throw new IllegalAccessError("The Botania API internal method handler has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Expected classname: " + expect + ", Actual classname: " + clname + ")");
        }
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new SyncHandler.ReloadListener());
    }

    private void serverStarting(FMLServerStartingEvent event) {
        if (gardenOfGlassLoaded) {
            CommandSkyblockSpread.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        }
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        ManaNetworkHandler.instance.clear();
    }

    static {
        finishedLoading = false;
        LOGGER = LogManager.getLogger((String)"botania");
    }
}

