/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.ModelAvatar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAvatar;

public class RenderTileAvatar
extends TileEntityRenderer<TileAvatar> {
    private static final float[] ROTATIONS = new float[]{180.0f, 0.0f, 90.0f, 270.0f};
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/avatar.png");
    private static final ModelAvatar model = new ModelAvatar();

    public void render(@Nullable TileAvatar avatar, double d0, double d1, double d2, float pticks, int digProgress) {
        if (!(avatar == null || avatar.func_145831_w().func_175667_e(avatar.func_174877_v()) && avatar.func_145831_w().func_180495_p(avatar.func_174877_v()).func_177230_c() == ModBlocks.avatar)) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)d0, (double)d1, (double)d2);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        Direction facing = avatar != null && avatar.func_145831_w() != null ? (Direction)avatar.func_145831_w().func_180495_p(avatar.func_174877_v()).func_177229_b(BotaniaStateProps.CARDINALS) : Direction.SOUTH;
        GlStateManager.translatef((float)0.5f, (float)1.6f, (float)0.5f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.rotatef((float)ROTATIONS[Math.max(Math.min(ROTATIONS.length - 1, facing.func_176745_a() - 2), 0)], (float)0.0f, (float)1.0f, (float)0.0f);
        model.render();
        if (avatar == null) {
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.enableRescaleNormal();
            GlStateManager.popMatrix();
            return;
        }
        ItemStack stack = avatar.getItemHandler().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            float s = 0.6f;
            GlStateManager.scalef((float)s, (float)s, (float)s);
            GlStateManager.translatef((float)-0.5f, (float)2.0f, (float)-0.25f);
            GlStateManager.rotatef((float)-70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
            GlStateManager.popMatrix();
            IAvatarWieldable wieldable = (IAvatarWieldable)stack.func_77973_b();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(wieldable.getOverlayResource(avatar, stack));
            s = 1.01f;
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.scalef((float)s, (float)s, (float)s);
            GlStateManager.translatef((float)0.0f, (float)-0.01f, (float)0.0f);
            int light = 0xF000F0;
            int lightmapX = light % 65536;
            int lightmapY = light / 65536;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
            float alpha = (float)Math.sin((double)ClientTickHandler.ticksInGame / 20.0) / 2.0f + 0.5f;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha + 0.183f));
            model.render();
            GlStateManager.popMatrix();
        }
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.popMatrix();
    }
}

