/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.entity.EntitySparkBase;

public abstract class RenderSparkBase<T extends EntitySparkBase>
extends EntityRenderer<T> {
    public RenderSparkBase(EntityRendererManager manager) {
        super(manager);
    }

    public void doRender(@Nonnull T tEntity, double par2, double par4, double par6, float par8, float par9) {
        TextureAtlasSprite iicon = this.getBaseIcon(tEntity);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)par2, (double)par4, (double)par6);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.alphaFunc((int)516, (float)0.05f);
        double time = (float)ClientTickHandler.ticksInGame + par9;
        float a = 0.1f + (float)(!tEntity.func_82150_aj() ? 1 : 0) * 0.8f;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((0.7f + 0.3f * (float)(Math.sin((time += (double)new Random(tEntity.func_145782_y()).nextInt()) / 5.0) + 0.5) * 2.0f) * a));
        float scale = 0.75f + 0.1f * (float)Math.sin(time / 10.0);
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        this.func_180548_c((Entity)tEntity);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.pushMatrix();
        float r = 180.0f - this.field_76990_c.field_78735_i;
        GlStateManager.rotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderIcon(tessellator, iicon);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(-0.02f + (float)Math.sin(time / 20.0) * 0.2f), (float)(0.24f + (float)Math.cos(time / 20.0) * 0.2f), (float)0.005f);
        GlStateManager.scalef((float)0.2f, (float)0.2f, (float)0.2f);
        this.colorStar(tEntity, a);
        this.renderIcon(tessellator, MiscellaneousIcons.INSTANCE.corporeaIconStar);
        GlStateManager.popMatrix();
        TextureAtlasSprite spinningIcon = this.getSpinningIcon(tEntity);
        if (spinningIcon != null) {
            GlStateManager.translatef((float)(-0.02f + (float)Math.sin(time / 20.0) * -0.2f), (float)(0.24f + (float)Math.cos(time / 20.0) * -0.2f), (float)0.005f);
            GlStateManager.scalef((float)0.2f, (float)0.2f, (float)0.2f);
            this.renderIcon(tessellator, spinningIcon);
        }
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderCallback(tEntity, par9);
        GlStateManager.disableBlend();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }

    protected TextureAtlasSprite getBaseIcon(T entity) {
        return MiscellaneousIcons.INSTANCE.sparkWorldIcon;
    }

    private void colorStar(T entity, float a) {
        int hex = ((EntitySparkBase)((Object)entity)).getNetwork().field_193351_w;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        GlStateManager.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)a);
    }

    @Nullable
    protected TextureAtlasSprite getSpinningIcon(T entity) {
        return null;
    }

    protected void renderCallback(T entity, float pticks) {
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntitySparkBase entity) {
        return AtlasTexture.field_110575_b;
    }

    private void renderIcon(Tessellator tess, TextureAtlasSprite icon) {
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        tess.func_178180_c().func_181668_a(7, ClientProxy.POSITION_TEX_LMAP_NORMAL);
        tess.func_178180_c().func_181662_b((double)(0.0f - f5), (double)(0.0f - f6), 0.0).func_187315_a((double)f, (double)f3).func_187314_a(240, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tess.func_178180_c().func_181662_b((double)(f4 - f5), (double)(0.0f - f6), 0.0).func_187315_a((double)f1, (double)f3).func_187314_a(240, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tess.func_178180_c().func_181662_b((double)(f4 - f5), (double)(f4 - f6), 0.0).func_187315_a((double)f1, (double)f2).func_187314_a(240, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tess.func_178180_c().func_181662_b((double)(0.0f - f5), (double)(f4 - f6), 0.0).func_187315_a((double)f, (double)f2).func_187314_a(240, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tess.func_78381_a();
    }
}

