/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.ModBlocks;

public class PlatformModel
implements IDynamicBakedModel {
    private final IBakedModel original;

    public PlatformModel(IBakedModel original) {
        this.original = original;
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        if (state == null) {
            return ImmutableList.of();
        }
        if (!(state.func_177230_c() instanceof BlockPlatform)) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_200117_a(state, side, rand);
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            layer = BlockRenderLayer.SOLID;
        }
        BlockState heldState = (BlockState)data.getData(BotaniaStateProps.HELD_STATE);
        BlockPos heldPos = (BlockPos)data.getData(BotaniaStateProps.HELD_POS);
        if (heldPos == null) {
            return ImmutableList.of();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (heldState == null && layer == BlockRenderLayer.SOLID) {
            return this.original.getQuads(state, side, rand, data);
        }
        if (heldState != null) {
            if (heldState.func_177230_c() == ModBlocks.manaGlass) {
                return ImmutableList.of();
            }
            if (heldState.func_177230_c().canRenderInLayer(heldState, layer)) {
                IBakedModel model = mc.func_175602_ab().func_175023_a().func_178125_b(heldState);
                return model.getQuads(heldState, side, rand, (IModelData)EmptyModelData.INSTANCE);
            }
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return this.original.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.original.func_188617_f();
    }
}

