/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.manapool;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ManaPoolRecipeCategory
implements IRecipeCategory<RecipeManaInfusion> {
    public static final ResourceLocation UID = new ResourceLocation("botania", "mana_pool");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((IItemProvider)ModBlocks.manaPool);

    public ManaPoolRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 64);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.manaPool", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 46);
        ItemNBTHelper.setBoolean(this.renderStack, "RenderFull", true);
        this.icon = guiHelper.createDrawableIngredient((Object)this.renderStack.func_77946_l());
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends RecipeManaInfusion> getRecipeClass() {
        return RecipeManaInfusion.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RecipeManaInfusion recipe, IIngredients iIngredients) {
        Block block;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(Arrays.asList(recipe.getInput().func_193365_a()));
        if (recipe.getCatalyst() != null && (block = recipe.getCatalyst().func_177230_c()).func_199767_j() != Items.field_190931_a) {
            builder.add((Object)ImmutableList.of((Object)new ItemStack((IItemProvider)block)));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void draw(RecipeManaInfusion recipe, double mouseX, double mouseY) {
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        this.overlay.draw(48, 0);
        HUDHandler.renderManaBar(28, 50, 255, 0.75f, recipe.getManaToConsume(), 100000);
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipeManaInfusion recipe, @Nonnull IIngredients ingredients) {
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 40, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        ++index;
        if (ingredients.getInputs(VanillaTypes.ITEM).size() > 1) {
            recipeLayout.getItemStacks().init(index, true, 20, 12);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
            ++index;
        }
        recipeLayout.getItemStacks().init(index, true, 70, 12);
        recipeLayout.getItemStacks().set(index, this.renderStack);
        recipeLayout.getItemStacks().init(++index, false, 99, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

