/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.core.handler.ConfigHandler;

public class FXSparkle
extends Particle {
    private static final ResourceLocation vanillaParticles = new ResourceLocation("textures/particle/particles.png");
    public static final ResourceLocation particles = new ResourceLocation("botania:textures/misc/particles.png");
    protected float particleScale;
    private final boolean corrupt;
    public final boolean fake;
    private final int multiplier;
    public final int particle = 16;
    private final boolean slowdown = true;
    private static final IParticleRenderType NORMAL_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "botania:sparkle";
        }
    };
    private static final IParticleRenderType CORRUPT_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
            ShaderHelper.useShader(ShaderHelper.filmGrain);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            ShaderHelper.releaseShader();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "botania:corrupt_sparkle";
        }
    };

    public FXSparkle(World world, double x, double y, double z, float size, float red, float green, float blue, int m, boolean fake, boolean noClip, boolean corrupt) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.particleScale = (this.field_187136_p.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.particle = 16;
        this.slowdown = true;
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.field_70545_g = 0.0f;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.particleScale *= size;
        this.field_70547_e = 3 * m;
        this.multiplier = m;
        this.func_187115_a(0.01f, 0.01f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.fake = fake;
        this.corrupt = corrupt;
        this.field_190017_n = !fake && !noClip;
    }

    public void setCanCollide(boolean canCollide) {
        this.field_190017_n = canCollide;
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        int part = 16 + this.field_70546_d / this.multiplier;
        float var8 = (float)(part % 8) / 8.0f;
        float var9 = var8 + 0.124875f;
        float var10 = (float)(part / 8) / 8.0f;
        float var11 = var10 + 0.124875f;
        float var12 = 0.1f * this.particleScale;
        boolean shrink = true;
        if (shrink) {
            var12 *= (float)(this.field_70547_e - this.field_70546_d + 1) / (float)this.field_70547_e;
        }
        float var13 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float var14 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float var15 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        float var16 = 1.0f;
        buffer.func_181662_b((double)(var13 - rotationX * var12 - rotationXY * var12), (double)(var14 - rotationZ * var12), (double)(var15 - rotationYZ * var12 - rotationXZ * var12)).func_187315_a((double)var9, (double)var11).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(var13 - rotationX * var12 + rotationXY * var12), (double)(var14 + rotationZ * var12), (double)(var15 - rotationYZ * var12 + rotationXZ * var12)).func_187315_a((double)var9, (double)var10).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(var13 + rotationX * var12 + rotationXY * var12), (double)(var14 + rotationZ * var12), (double)(var15 + rotationYZ * var12 + rotationXZ * var12)).func_187315_a((double)var8, (double)var10).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(var13 + rotationX * var12 - rotationXY * var12), (double)(var14 - rotationZ * var12), (double)(var15 + rotationYZ * var12 - rotationXZ * var12)).func_187315_a((double)var8, (double)var11).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        if (this.field_190017_n && !this.fake) {
            this.wiggleAround(this.field_187126_f, (this.func_187116_l().field_72338_b + this.func_187116_l().field_72337_e) / 2.0, this.field_187128_h);
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.9080000019073486;
        this.field_187130_j *= 0.9080000019073486;
        this.field_187131_k *= 0.9080000019073486;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        if (this.fake && this.field_70546_d > 1) {
            this.func_187112_i();
        }
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return this.corrupt ? CORRUPT_RENDER : NORMAL_RENDER;
    }

    public void setGravity(float value) {
        this.field_70545_g = value;
    }

    private void wiggleAround(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vec3d vec3d = new Vec3d(x - (double)blockpos.func_177958_n(), y - (double)blockpos.func_177956_o(), z - (double)blockpos.func_177952_p());
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(direction1);
            if (Block.func_208062_a((VoxelShape)this.field_187122_b.func_180495_p((BlockPos)blockpos$mutableblockpos).func_196952_d((IBlockReader)this.field_187122_b, (BlockPos)blockpos$mutableblockpos))) continue;
            double d1 = vec3d.func_216370_a(direction1.func_176740_k());
            double d = d2 = direction1.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_187136_p.nextFloat() * 0.05f + 0.025f;
        float f1 = direction.func_176743_c().func_179524_a();
        float secondary = (this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.1f;
        float secondary2 = (this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.1f;
        if (direction.func_176740_k() == Direction.Axis.X) {
            this.field_187129_i = f1 * f;
            this.field_187130_j = secondary;
            this.field_187131_k = secondary2;
        } else if (direction.func_176740_k() == Direction.Axis.Y) {
            this.field_187129_i = secondary;
            this.field_187130_j = f1 * f;
            this.field_187131_k = secondary2;
        } else if (direction.func_176740_k() == Direction.Axis.Z) {
            this.field_187129_i = secondary;
            this.field_187130_j = secondary2;
            this.field_187131_k = f1 * f;
        }
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        GL11.glPushAttrib((int)64);
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)1);
        GlStateManager.alphaFunc((int)516, (float)0.003921569f);
        GlStateManager.disableLighting();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        textureManager.func_110577_a((Boolean)ConfigHandler.CLIENT.matrixMode.get() != false ? vanillaParticles : particles);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
    }

    private static void endRenderCommon() {
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GL11.glPopAttrib();
    }
}

