/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.client.book.gui.GuiBook;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public class RenderLexicon {
    private static final BookModel model = new BookModel();
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/lexicon_default.png");
    private static final ResourceLocation elvenTexture = new ResourceLocation("botania:textures/model/lexicon_elven.png");
    private static final String[] QUOTES = new String[]{"\"Neat!\" - Direwolf20", "\"It's pretty ledge.\" - Haighyorkie", "\"I don't really like it.\" - CrustyMustard", "\"It's a very thinky mod.\" - AdamG3691", "\"You must craft the tiny potato.\" - TheFractangle", "\"Vazkii did a thing.\" - cpw"};
    private static int quote = -1;

    @SubscribeEvent
    public static void renderItem(RenderSpecificHandEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!((Boolean)ConfigHandler.CLIENT.lexicon3dModel.get()).booleanValue() || mc.field_71474_y.field_74320_O != 0 || mc.field_71439_g.func_184586_b(evt.getHand()).func_190926_b() || mc.field_71439_g.func_184586_b(evt.getHand()).func_77973_b() != ModItems.lexicon) {
            return;
        }
        evt.setCanceled(true);
        try {
            RenderLexicon.renderItemInFirstPerson((AbstractClientPlayerEntity)mc.field_71439_g, evt.getPartialTicks(), evt.getInterpolatedPitch(), evt.getHand(), evt.getSwingProgress(), evt.getItemStack(), evt.getEquipProgress());
        }
        catch (Throwable throwable) {
            Botania.LOGGER.warn("Failed to render lexicon");
        }
    }

    private static void renderItemInFirstPerson(AbstractClientPlayerEntity player, float partialTicks, float interpPitch, Hand hand, float swingProgress, ItemStack stack, float equipProgress) throws Throwable {
        boolean flag = hand == Hand.MAIN_HAND;
        HandSide enumhandside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.pushMatrix();
        boolean flag1 = enumhandside == HandSide.RIGHT;
        float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
        float f2 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        int i = flag1 ? 1 : -1;
        GlStateManager.translated((double)((float)i * f), (double)f1, (double)f2);
        RenderLexicon.transformSideFirstPerson(enumhandside, equipProgress);
        RenderLexicon.transformFirstPerson(enumhandside, swingProgress);
        RenderLexicon.doRender(enumhandside, partialTicks, stack);
        GlStateManager.popMatrix();
    }

    private static void doRender(HandSide side, float partialTicks, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.pushMatrix();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(((ItemLexicon)ModItems.lexicon).isElvenItem(stack) ? elvenTexture : texture);
        float ticks = ClientTickHandler.ticksWithLexicaOpen;
        if (ticks > 0.0f && ticks < 10.0f) {
            ticks = Minecraft.func_71410_x().field_71462_r instanceof GuiBook && ((GuiBook)Minecraft.func_71410_x().field_71462_r).book.getBookItem().func_77973_b() == ModItems.lexicon ? (ticks += partialTicks) : (ticks -= partialTicks);
        }
        GlStateManager.translated((double)(0.3f + 0.02f * ticks), (double)(0.475f + 0.01f * ticks), (double)(-0.2f - (side == HandSide.RIGHT ? 0.035f : 0.01f) * ticks));
        GlStateManager.rotatef((float)(87.5f + ticks * (float)(side == HandSide.RIGHT ? 8 : 12)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(ticks * 2.85f), (float)0.0f, (float)0.0f, (float)1.0f);
        float opening = ticks / 12.0f;
        float pageFlipTicks = ClientTickHandler.pageFlipTicks;
        if (pageFlipTicks > 0.0f) {
            pageFlipTicks -= ClientTickHandler.partialTicks;
        }
        float pageFlip = pageFlipTicks / 5.0f;
        model.func_217103_a(0.0f, 0.0f, pageFlip, opening, 0.0f, 0.0625f);
        if (ticks < 3.0f) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translatef((float)-0.3f, (float)-0.24f, (float)-0.07f);
            GlStateManager.scalef((float)0.003f, (float)0.003f, (float)-0.003f);
            String title = ItemLexicon.getTitle(stack).func_150254_d();
            font.func_211126_b(font.func_78269_a(title, 80), 0.0f, 0.0f, 14063360);
            GlStateManager.translatef((float)0.0f, (float)10.0f, (float)0.0f);
            GlStateManager.scalef((float)0.6f, (float)0.6f, (float)0.6f);
            font.func_211126_b(TextFormatting.ITALIC + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"botaniamisc.edition", (Object[])new Object[]{ItemLexicon.getEdition()}), 0.0f, 0.0f, 10514688);
            if (quote == -1) {
                quote = mc.field_71441_e.field_73012_v.nextInt(QUOTES.length);
            }
            String quoteStr = QUOTES[quote];
            GlStateManager.translatef((float)-5.0f, (float)15.0f, (float)0.0f);
            RenderLexicon.renderText(0, 0, 140, 100, 0, false, 7995282, quoteStr);
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.translatef((float)8.0f, (float)110.0f, (float)0.0f);
            font.func_211126_b(I18n.func_135052_a((String)"botaniamisc.lexiconcover0", (Object[])new Object[0]), 0.0f, 0.0f, 7995282);
            GlStateManager.translatef((float)0.0f, (float)10.0f, (float)0.0f);
            font.func_211126_b(TextFormatting.UNDERLINE + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"botaniamisc.lexiconcover1", (Object[])new Object[0]), 0.0f, 0.0f, 7995282);
            GlStateManager.translatef((float)0.0f, (float)-30.0f, (float)0.0f);
            String authorTitle = I18n.func_135052_a((String)"botaniamisc.lexiconcover2", (Object[])new Object[0]);
            int len = font.func_78256_a(authorTitle);
            font.func_211126_b(authorTitle, (float)(58 - len / 2), -8.0f, 14063360);
        }
        GlStateManager.popMatrix();
    }

    private static void transformSideFirstPerson(HandSide p_187459_1_, float p_187459_2_) {
        int i = p_187459_1_ == HandSide.RIGHT ? 1 : -1;
        GlStateManager.translatef((float)((float)i * 0.56f), (float)(-0.44f + p_187459_2_ * -0.8f), (float)-0.72f);
    }

    private static void transformFirstPerson(HandSide p_187453_1_, float p_187453_2_) {
        int i = p_187453_1_ == HandSide.RIGHT ? 1 : -1;
        GlStateManager.translatef((float)(p_187453_1_ == HandSide.RIGHT ? 0.2f : 0.52f), (float)-0.125f, (float)(p_187453_1_ == HandSide.RIGHT ? 0.6f : 0.25f));
        GlStateManager.rotatef((float)(p_187453_1_ == HandSide.RIGHT ? 60.0f : 120.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        float f = MathHelper.func_76126_a((float)(p_187453_2_ * p_187453_2_ * (float)Math.PI));
        GlStateManager.rotatef((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187453_2_) * (float)Math.PI));
        GlStateManager.rotatef((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    /*
     * WARNING - void declaration
     */
    private static void renderText(int x, int y, int width, int height, int paragraphSize, boolean useUnicode, int color, String unlocalizedText) {
        void var15_17;
        x += 2;
        y += 10;
        width -= 4;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String text = I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]).replaceAll("&", "\u00a7");
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        String[] stringArray = textEntries;
        int n = stringArray.length;
        boolean bl = false;
        while (var15_17 < n) {
            String[] tokens;
            String s = stringArray[var15_17];
            ArrayList<String> words = new ArrayList<String>();
            String lineStr = "";
            for (String token : tokens = s.split(" ")) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = lineStr + spaced;
                String controlCodes = RenderLexicon.toControlCodes(RenderLexicon.getControlCodes(prev));
                if (font.func_78256_a(lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add(controlCodes + token);
            }
            if (!lineStr.isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
            ++var15_17;
        }
        int i = 0;
        for (List list : lines) {
            boolean justify;
            list.size();
            int xi = x;
            int spacing = 4;
            int wcount = list.size();
            int compensationSpaces = 0;
            boolean bl2 = justify = (Boolean)ConfigHandler.CLIENT.lexiconJustifiedText.get() != false && wcount > 0 && lines.size() > i && !((List)lines.get(i + 1)).isEmpty();
            if (justify) {
                String s = Joiner.on((String)"").join((Iterable)list);
                int swidth = font.func_78256_a(s);
                int space = width - swidth;
                spacing = wcount == 1 ? 0 : space / (wcount - 1);
                compensationSpaces = wcount == 1 ? 0 : space % (wcount - 1);
            }
            for (String s : list) {
                int extra = 0;
                if (compensationSpaces > 0) {
                    --compensationSpaces;
                    ++extra;
                }
                font.func_211126_b(s, (float)xi, (float)y, color);
                xi += font.func_78256_a(s) + spacing + extra;
            }
            y += list.isEmpty() ? paragraphSize : 10;
            ++i;
        }
    }

    private static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        return controls.replaceAll(".*r", "r");
    }

    private static String toControlCodes(String s) {
        return s.replaceAll(".", "\u00a7$0");
    }
}

