/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RecipeElvenTrade {
    private final ResourceLocation id;
    private final ImmutableList<ItemStack> outputs;
    private final ImmutableList<Ingredient> inputs;

    public RecipeElvenTrade(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
        this(id, new ItemStack[]{output}, inputs);
    }

    public RecipeElvenTrade(ResourceLocation id, ItemStack[] outputs, Ingredient ... inputs) {
        this.id = id;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
        this.inputs = ImmutableList.copyOf((Object[])inputs);
    }

    public boolean matches(List<ItemStack> stacks, boolean remove) {
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        ArrayList<ItemStack> stacksToRemove = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            if (inputsMissing.isEmpty()) break;
            int stackIndex = -1;
            for (int i = 0; i < inputsMissing.size(); ++i) {
                Ingredient ingr = (Ingredient)inputsMissing.get(i);
                if (!ingr.test(stack)) continue;
                if (!stacksToRemove.contains(stack)) {
                    stacksToRemove.add(stack);
                }
                stackIndex = i;
                break;
            }
            if (stackIndex == -1) continue;
            inputsMissing.remove(stackIndex);
        }
        if (remove) {
            for (ItemStack r : stacksToRemove) {
                stacks.remove(r);
            }
        }
        return inputsMissing.isEmpty();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        buf.func_150787_b(this.inputs.size());
        for (Ingredient input : this.inputs) {
            input.func_199564_a(buf);
        }
        buf.func_150787_b(this.outputs.size());
        for (ItemStack output : this.outputs) {
            buf.writeItemStack(output, false);
        }
    }

    public static RecipeElvenTrade read(PacketBuffer buf) {
        ResourceLocation id = buf.func_192575_l();
        Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
        }
        ItemStack[] outputs = new ItemStack[buf.func_150792_a()];
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = buf.func_150791_c();
        }
        return new RecipeElvenTrade(id, outputs, inputs);
    }
}

