/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.DummyMethodHandler;
import vazkii.botania.api.internal.IInternalMethodHandler;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.recipe.RecipeRuneAltar;

public final class BotaniaAPI {
    @CapabilityInject(value=IFloatingFlower.class)
    public static Capability<IFloatingFlower> FLOATING_FLOWER_CAP;
    public static final Map<String, Brew> brewMap;
    public static Map<ResourceLocation, RecipePetals> petalRecipes;
    public static Map<ResourceLocation, RecipePureDaisy> pureDaisyRecipes;
    public static Map<ResourceLocation, RecipeManaInfusion> manaInfusionRecipes;
    public static Map<ResourceLocation, RecipeRuneAltar> runeAltarRecipes;
    public static Map<ResourceLocation, RecipeElvenTrade> elvenTradeRecipes;
    public static Map<ResourceLocation, RecipeBrew> brewRecipes;
    public static Map<ResourceLocation, Integer> oreWeights;
    public static Map<ResourceLocation, Integer> oreWeightsNether;
    public static Map<IRegistryDelegate<Block>, Function<DyeColor, Block>> paintableBlocks;
    private static final int[] MAX_DAMAGE_ARRAY;
    public static final IArmorMaterial MANASTEEL_ARMOR_MAT;
    public static final IItemTier MANASTEEL_ITEM_TIER;
    public static final IArmorMaterial ELEMENTIUM_ARMOR_MAT;
    public static final IItemTier ELEMENTIUM_ITEM_TIER;
    public static final IArmorMaterial TERRASTEEL_ARMOR_MAT;
    public static final IItemTier TERRASTEEL_ITEM_TIER;
    public static final IArmorMaterial MANAWEAVE_ARMOR_MAT;
    public static final Rarity rarityRelic;
    public static final Brew fallbackBrew;
    public static volatile IInternalMethodHandler internalHandler;

    public static Brew registerBrew(Brew brew) {
        brewMap.put(brew.getKey(), brew);
        return brew;
    }

    public static Brew getBrewFromKey(String key) {
        if (brewMap.containsKey(key)) {
            return brewMap.get(key);
        }
        return fallbackBrew;
    }

    public static int getOreWeight(ResourceLocation tag) {
        return oreWeights.get(tag);
    }

    public static int getOreWeightNether(ResourceLocation tag) {
        return oreWeightsNether.get(tag);
    }

    static {
        brewMap = new LinkedHashMap<String, Brew>();
        petalRecipes = Collections.emptyMap();
        pureDaisyRecipes = Collections.emptyMap();
        manaInfusionRecipes = Collections.emptyMap();
        runeAltarRecipes = Collections.emptyMap();
        elvenTradeRecipes = Collections.emptyMap();
        brewRecipes = Collections.emptyMap();
        oreWeights = Collections.emptyMap();
        oreWeightsNether = Collections.emptyMap();
        paintableBlocks = Collections.emptyMap();
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        MANASTEEL_ARMOR_MAT = new IArmorMaterial(){
            private final int[] damageReduction = new int[]{2, 5, 6, 2};

            public int func_200896_a(EquipmentSlotType slotIn) {
                return 16 * MAX_DAMAGE_ARRAY[slotIn.func_188454_b()];
            }

            public int func_200902_b(EquipmentSlotType slotIn) {
                return this.damageReduction[slotIn.func_188454_b()];
            }

            public int func_200900_a() {
                return 18;
            }

            public SoundEvent func_200899_b() {
                return SoundEvents.field_187725_r;
            }

            public Ingredient func_200898_c() {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "manasteel_ingot"));
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            }

            public String func_200897_d() {
                return "manasteel";
            }

            public float func_200901_e() {
                return 0.0f;
            }
        };
        MANASTEEL_ITEM_TIER = new IItemTier(){

            public int func_200926_a() {
                return 300;
            }

            public float func_200928_b() {
                return 6.2f;
            }

            public float func_200929_c() {
                return 2.0f;
            }

            public int func_200925_d() {
                return 3;
            }

            public int func_200927_e() {
                return 20;
            }

            @Nonnull
            public Ingredient func_200924_f() {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "manasteel_ingot"));
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            }
        };
        ELEMENTIUM_ARMOR_MAT = new IArmorMaterial(){
            private final int[] damageReduction = new int[]{2, 5, 6, 2};

            public int func_200896_a(EquipmentSlotType slotIn) {
                return 18 * MAX_DAMAGE_ARRAY[slotIn.func_188454_b()];
            }

            public int func_200902_b(EquipmentSlotType slotIn) {
                return this.damageReduction[slotIn.func_188454_b()];
            }

            public int func_200900_a() {
                return 18;
            }

            public SoundEvent func_200899_b() {
                return SoundEvents.field_187725_r;
            }

            public Ingredient func_200898_c() {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "elementium_ingot"));
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            }

            public String func_200897_d() {
                return "elementium";
            }

            public float func_200901_e() {
                return 0.0f;
            }
        };
        ELEMENTIUM_ITEM_TIER = new IItemTier(){

            public int func_200926_a() {
                return 720;
            }

            public float func_200928_b() {
                return 6.2f;
            }

            public float func_200929_c() {
                return 2.0f;
            }

            public int func_200925_d() {
                return 3;
            }

            public int func_200927_e() {
                return 20;
            }

            @Nonnull
            public Ingredient func_200924_f() {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "manasteel_ingot"));
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            }
        };
        TERRASTEEL_ARMOR_MAT = new IArmorMaterial(){
            private final int[] damageReduction = new int[]{3, 6, 8, 3};

            public int func_200896_a(EquipmentSlotType slotIn) {
                return 34 * MAX_DAMAGE_ARRAY[slotIn.func_188454_b()];
            }

            public int func_200902_b(EquipmentSlotType slotIn) {
                return this.damageReduction[slotIn.func_188454_b()];
            }

            public int func_200900_a() {
                return 26;
            }

            public SoundEvent func_200899_b() {
                return SoundEvents.field_187716_o;
            }

            public Ingredient func_200898_c() {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "terrasteel_ingot"));
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            }

            public String func_200897_d() {
                return "terrasteel";
            }

            public float func_200901_e() {
                return 3.0f;
            }
        };
        TERRASTEEL_ITEM_TIER = new IItemTier(){

            public int func_200926_a() {
                return 2300;
            }

            public float func_200928_b() {
                return 9.0f;
            }

            public float func_200929_c() {
                return 3.0f;
            }

            public int func_200925_d() {
                return 4;
            }

            public int func_200927_e() {
                return 26;
            }

            @Nonnull
            public Ingredient func_200924_f() {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "terrasteel_ingot"));
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            }
        };
        MANAWEAVE_ARMOR_MAT = new IArmorMaterial(){
            private final int[] damageReduction = new int[]{1, 2, 2, 1};

            public int func_200896_a(EquipmentSlotType slotIn) {
                return 5 * MAX_DAMAGE_ARRAY[slotIn.func_188454_b()];
            }

            public int func_200902_b(EquipmentSlotType slotIn) {
                return this.damageReduction[slotIn.func_188454_b()];
            }

            public int func_200900_a() {
                return 18;
            }

            public SoundEvent func_200899_b() {
                return SoundEvents.field_187728_s;
            }

            public Ingredient func_200898_c() {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "manaweave_cloth"));
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            }

            public String func_200897_d() {
                return "manaweave";
            }

            public float func_200901_e() {
                return 0.0f;
            }
        };
        rarityRelic = Rarity.create((String)"RELIC", (TextFormatting)TextFormatting.GOLD);
        fallbackBrew = new Brew("fallback", "botania.brew.fallback", 0, 0, new EffectInstance[0]);
        internalHandler = new DummyMethodHandler();
    }
}

