/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.ISubTileContainer;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.ItemTwigWand;

public class ItemObedienceStick
extends ItemMod {
    public ItemObedienceStick() {
        super("obedienceStick");
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xs, float ys, float zs) {
        TileEntity tileAt = world.func_175625_s(pos);
        if (tileAt != null && (tileAt instanceof IManaPool || tileAt instanceof IManaCollector)) {
            boolean pool = tileAt instanceof IManaPool;
            Actuator act = pool ? Actuator.functionalActuator : Actuator.generatingActuator;
            int range = pool ? 10 : 6;
            for (BlockPos pos_ : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range))) {
                SubTileEntity subtile;
                TileEntity tile;
                if (pos_.func_177951_i((Vec3i)pos) > (double)(range * range) || !((tile = world.func_175625_s(pos_)) instanceof ISubTileContainer) || !act.actuate(subtile = ((ISubTileContainer)tile).getSubTile(), tileAt)) continue;
                Vector3 orig = new Vector3((double)pos_.func_177958_n() + 0.5, (double)pos_.func_177956_o() + 0.5, (double)pos_.func_177952_p() + 0.5);
                Vector3 end = new Vector3((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                ItemTwigWand.doParticleBeam(world, orig, end);
            }
            if (player.field_70170_p.field_72995_K) {
                player.func_184609_a(hand);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static abstract class Actuator {
        public static final Actuator generatingActuator = new Actuator(){

            @Override
            public boolean actuate(SubTileEntity flower, TileEntity tile) {
                if (flower instanceof SubTileGenerating) {
                    ((SubTileGenerating)flower).linkToForcefully(tile);
                    return true;
                }
                return false;
            }
        };
        public static final Actuator functionalActuator = new Actuator(){

            @Override
            public boolean actuate(SubTileEntity flower, TileEntity tile) {
                if (flower instanceof SubTileFunctional) {
                    ((SubTileFunctional)flower).linkToForcefully(tile);
                    return true;
                }
                return false;
            }
        };

        public abstract boolean actuate(SubTileEntity var1, TileEntity var2);
    }
}

