/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.buildcraft;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerInternalSided;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementManager;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import vazkii.botania.api.mana.IManaBlock;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.integration.buildcraft.TriggerManaDetector;
import vazkii.botania.common.integration.buildcraft.TriggerManaLevel;
import vazkii.botania.common.integration.buildcraft.TriggerRuneAltarCanCraft;

public class StatementAPIPlugin
implements ITriggerProvider {
    static final ITriggerExternal triggerManaEmpty = new TriggerManaLevel(TriggerManaLevel.State.EMPTY);
    static final ITriggerExternal triggerManaContains = new TriggerManaLevel(TriggerManaLevel.State.CONTAINS);
    static final ITriggerExternal triggerManaSpace = new TriggerManaLevel(TriggerManaLevel.State.SPACE);
    static final ITriggerExternal triggerManaFull = new TriggerManaLevel(TriggerManaLevel.State.FULL);
    private static final ITriggerInternal triggerManaDetector = new TriggerManaDetector();
    private static final ITriggerExternal triggerRuneAltarCanCraft = new TriggerRuneAltarCanCraft();

    public StatementAPIPlugin() {
        StatementManager.registerStatement((IStatement)triggerManaEmpty);
        StatementManager.registerStatement((IStatement)triggerManaContains);
        StatementManager.registerStatement((IStatement)triggerManaSpace);
        StatementManager.registerStatement((IStatement)triggerManaFull);
        StatementManager.registerStatement((IStatement)triggerManaDetector);
        StatementManager.registerStatement((IStatement)triggerRuneAltarCanCraft);
        StatementManager.registerTriggerProvider((ITriggerProvider)this);
    }

    public void addInternalTriggers(Collection<ITriggerInternal> triggers, IStatementContainer container) {
        triggers.add(triggerManaDetector);
    }

    public void addInternalSidedTriggers(Collection<ITriggerInternalSided> triggers, IStatementContainer container, @Nonnull EnumFacing side) {
    }

    public void addExternalTriggers(Collection<ITriggerExternal> triggers, @Nonnull EnumFacing side, TileEntity tile) {
        if (tile instanceof IManaBlock) {
            triggers.add(triggerManaEmpty);
            triggers.add(triggerManaContains);
            if (tile instanceof IManaReceiver) {
                triggers.add(triggerManaSpace);
                triggers.add(triggerManaFull);
            }
        }
        if (tile instanceof TileRuneAltar) {
            triggers.add(triggerRuneAltarCanCraft);
        }
    }
}

