/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.item.IHourglassTrigger;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileAnimatedTorch;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockAnimatedTorch
extends BlockMod
implements IWandable,
IManaTrigger,
IHourglassTrigger,
IWandHUD,
ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockAnimatedTorch() {
        super(Material.field_151594_q, "animatedTorch");
        this.func_149715_a(0.5f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && playerIn.func_70093_af() && playerIn.func_184586_b(hand).func_190926_b()) {
            ((TileAnimatedTorch)worldIn.func_175625_s(pos)).handRotate();
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).onPlace(entity);
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        if (!burst.isFake()) {
            ((TileAnimatedTorch)world.func_175625_s(pos)).toggle();
        }
    }

    @Override
    public void onTriggeredByHourglass(World world, BlockPos pos, TileEntity hourglass) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).toggle();
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).onWanded();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileAnimatedTorch tile = (TileAnimatedTorch)blockAccess.func_175625_s(pos);
        if (tile.rotating) {
            return 0;
        }
        if (TileAnimatedTorch.SIDES[tile.side] == side) {
            return 15;
        }
        return 0;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileAnimatedTorch();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            world.func_175685_c(pos.func_177972_a(side), (Block)this, false);
        }
        super.func_176206_d(world, pos, state);
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.animatedTorch;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        super.registerModels();
        ModelHandler.registerCustomItemblock(this, "animatedtorch");
    }
}

