/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import vazkii.botania.api.corporea.CorporeaHelper;

public class CorporeaAutoCompleteHandler {
    private boolean isAutoCompleted = false;
    private String originalString = "";
    private List<CompletionData> completions = new ArrayList<CompletionData>();
    private int position;
    static final TreeSet<String> itemNames = new TreeSet(String::compareToIgnoreCase);
    private boolean tabLastTick = false;

    public static void updateItemList() {
        itemNames.clear();
        Iterator iterator = Item.field_150901_e.iterator();
        NonNullList curList = NonNullList.func_191196_a();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (item == null || item.func_77640_w() == null) continue;
            curList.clear();
            try {
                item.func_150895_a(null, curList);
                for (ItemStack stack : curList) {
                    itemNames.add(CorporeaHelper.stripControlCodes(stack.func_82833_r().trim()));
                }
            }
            catch (Exception exception) {
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        boolean valid;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof GuiChat)) {
            this.isAutoCompleted = false;
            return;
        }
        GuiChat chat = (GuiChat)screen;
        if (this.isAutoCompleted && !(valid = false)) {
            this.isAutoCompleted = false;
        }
        if (Keyboard.isKeyDown((int)15)) {
            if (this.tabLastTick) {
                return;
            }
        } else {
            this.tabLastTick = false;
            return;
        }
        this.tabLastTick = true;
        if (!CorporeaHelper.shouldAutoComplete()) {
            return;
        }
        if (!this.isAutoCompleted) {
            this.buildAutoCompletes(chat.field_146415_a, chat);
        }
        if (this.isAutoCompleted && !this.completions.isEmpty()) {
            this.advanceAutoComplete(chat.field_146415_a, chat);
        }
    }

    private void advanceAutoComplete(GuiTextField inputField, GuiChat chat) {
        ++this.position;
        if (this.position >= this.completions.size()) {
            this.position -= this.completions.size();
        }
        CompletionData data = this.completions.get(this.position);
        String str = this.originalString.substring(0, this.originalString.length() - data.prefixLength) + data.string;
        inputField.func_146180_a(str);
    }

    private void buildAutoCompletes(GuiTextField inputField, GuiChat chat) {
        String leftOfCursor = inputField.func_146198_h() == 0 ? "" : inputField.func_146179_b().substring(0, inputField.func_146198_h());
        if (leftOfCursor.length() == 0 || leftOfCursor.charAt(0) == '/') {
            return;
        }
        this.completions = this.getNames(leftOfCursor);
        if (this.completions.isEmpty()) {
            return;
        }
        this.position = -1;
        StringBuilder stringbuilder = new StringBuilder();
        for (CompletionData data : this.completions) {
            if (stringbuilder.length() > 0) {
                stringbuilder.append(", ");
            }
            stringbuilder.append(data.string);
        }
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TextComponentString(stringbuilder.toString()), 1);
        this.isAutoCompleted = true;
        this.originalString = inputField.func_146179_b();
    }

    private List<CompletionData> getNames(String prefix) {
        String s = prefix.trim();
        if (s.isEmpty()) {
            return ImmutableList.of();
        }
        TreeSet<CompletionData> result = new TreeSet<CompletionData>();
        String[] words = s.split(" ");
        int i = words.length - 1;
        String curPrefix = words[i];
        while (i >= 0) {
            result.addAll(this.getNamesStartingWith(curPrefix.toLowerCase()));
            if (--i < 0) continue;
            curPrefix = words[i] + " " + curPrefix;
        }
        return new ArrayList<CompletionData>(result);
    }

    private List<CompletionData> getNamesStartingWith(String prefix) {
        ArrayList<CompletionData> result = new ArrayList<CompletionData>();
        int length = prefix.length();
        SortedSet<String> after = itemNames.tailSet(prefix);
        for (String str : after) {
            if (str.toLowerCase().startsWith(prefix)) {
                result.add(new CompletionData(str, length));
                continue;
            }
            return result;
        }
        return result;
    }

    private static class CompletionData
    implements Comparable<CompletionData> {
        private final String string;
        private final int prefixLength;

        public CompletionData(String string, int prefixLength) {
            this.string = string;
            this.prefixLength = prefixLength;
        }

        @Override
        public int compareTo(@Nonnull CompletionData arg0) {
            return this.string.compareTo(arg0.string);
        }
    }
}

