/**
 * This class was created by <Vazkii>. It's distributed as
 * part of the Botania Mod. Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 *
 * File Created @ [Jan 14, 2014, 5:17:47 PM (GMT)]
 */
package vazkii.botania.common.item;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.brew.ItemBrewFlask;
import vazkii.botania.common.item.brew.ItemBrewVial;
import vazkii.botania.common.item.brew.ItemIncenseStick;
import vazkii.botania.common.item.brew.ItemVial;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumBoots;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumChest;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumHelm;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumLegs;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelBoots;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelChest;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelHelm;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelLegs;
import vazkii.botania.common.item.equipment.armor.manaweave.ItemManaweaveBoots;
import vazkii.botania.common.item.equipment.armor.manaweave.ItemManaweaveChest;
import vazkii.botania.common.item.equipment.armor.manaweave.ItemManaweaveHelm;
import vazkii.botania.common.item.equipment.armor.manaweave.ItemManaweaveLegs;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelBoots;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelChest;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelHelm;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelLegs;
import vazkii.botania.common.item.equipment.bauble.*;
import vazkii.botania.common.item.equipment.tool.ItemEnderDagger;
import vazkii.botania.common.item.equipment.tool.ItemGlassPick;
import vazkii.botania.common.item.equipment.tool.ItemStarSword;
import vazkii.botania.common.item.equipment.tool.ItemThunderSword;
import vazkii.botania.common.item.equipment.tool.bow.ItemCrystalBow;
import vazkii.botania.common.item.equipment.tool.bow.ItemLivingwoodBow;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumAxe;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumPick;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumShears;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumShovel;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumSword;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelAxe;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelPick;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelShears;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelShovel;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelSword;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.item.interaction.thaumcraft.ItemElementiumHelmRevealing;
import vazkii.botania.common.item.interaction.thaumcraft.ItemManaInkwell;
import vazkii.botania.common.item.interaction.thaumcraft.ItemManasteelHelmRevealing;
import vazkii.botania.common.item.interaction.thaumcraft.ItemTerrasteelHelmRevealing;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.material.ItemDye;
import vazkii.botania.common.item.material.ItemManaResource;
import vazkii.botania.common.item.material.ItemPestleAndMortar;
import vazkii.botania.common.item.material.ItemPetal;
import vazkii.botania.common.item.material.ItemQuartz;
import vazkii.botania.common.item.material.ItemRune;
import vazkii.botania.common.item.record.ItemRecordGaia1;
import vazkii.botania.common.item.record.ItemRecordGaia2;
import vazkii.botania.common.item.relic.ItemDice;
import vazkii.botania.common.item.relic.ItemFlugelEye;
import vazkii.botania.common.item.relic.ItemInfiniteFruit;
import vazkii.botania.common.item.relic.ItemKingKey;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.item.relic.ItemOdinRing;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.common.item.rod.ItemCobbleRod;
import vazkii.botania.common.item.rod.ItemDirtRod;
import vazkii.botania.common.item.rod.ItemDiviningRod;
import vazkii.botania.common.item.rod.ItemExchangeRod;
import vazkii.botania.common.item.rod.ItemFireRod;
import vazkii.botania.common.item.rod.ItemGravityRod;
import vazkii.botania.common.item.rod.ItemMissileRod;
import vazkii.botania.common.item.rod.ItemRainbowRod;
import vazkii.botania.common.item.rod.ItemSkyDirtRod;
import vazkii.botania.common.item.rod.ItemSmeltRod;
import vazkii.botania.common.item.rod.ItemTerraformRod;
import vazkii.botania.common.item.rod.ItemTornadoRod;
import vazkii.botania.common.item.rod.ItemWaterRod;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.common.lib.LibOreDict;

@Mod.EventBusSubscriber(modid = LibMisc.MOD_ID)
public final class ModItems {
	public static final Item lexicon = new ItemLexicon();
	public static final Item petal = new ItemPetal();
	public static final Item dye = new ItemDye();
	public static final Item pestleAndMortar = new ItemPestleAndMortar();
	public static final Item twigWand = new ItemTwigWand();
	public static final Item manaResource = new ItemManaResource();
	public static final Item lens = new ItemLens();
	public static final Item rune = new ItemRune();
	public static final Item manaTablet = new ItemManaTablet();
	public static final Item manaGun = new ItemManaGun();
	public static final Item manaCookie = new ItemManaCookie();
	public static final Item fertilizer = new ItemFertilizer();
	public static final Item grassSeeds = new ItemGrassSeeds();
	public static final Item dirtRod = new ItemDirtRod();
	public static final Item terraformRod = new ItemTerraformRod();
	public static final Item grassHorn = new ItemGrassHorn();
	public static final Item manaMirror = new ItemManaMirror();
	public static final Item manasteelHelm = new ItemManasteelHelm();
	public static final Item manasteelHelmRevealing = new ItemManasteelHelmRevealing();
	public static final Item manasteelChest = new ItemManasteelChest();
	public static final Item manasteelLegs = new ItemManasteelLegs();
	public static final Item manasteelBoots = new ItemManasteelBoots();
	public static final Item manasteelPick = new ItemManasteelPick();
	public static final Item manasteelShovel = new ItemManasteelShovel();
	public static final Item manasteelAxe = new ItemManasteelAxe();
	public static final Item manasteelSword = new ItemManasteelSword();
	public static final Item manasteelShears = new ItemManasteelShears();
	public static final Item terrasteelHelm = new ItemTerrasteelHelm();
	public static final Item terrasteelHelmRevealing = new ItemTerrasteelHelmRevealing();
	public static final Item terrasteelChest = new ItemTerrasteelChest();
	public static final Item terrasteelLegs = new ItemTerrasteelLegs();
	public static final Item terrasteelBoots = new ItemTerrasteelBoots();
	public static final Item terraSword = new ItemTerraSword();
	public static final Item tinyPlanet = new ItemTinyPlanet();
	public static final Item manaRing = new ItemManaRing();
	public static final Item auraRing = new ItemAuraRing();
	public static final Item manaRingGreater = new ItemGreaterManaRing();
	public static final Item auraRingGreater = new ItemGreaterAuraRing();
	public static final Item travelBelt = new ItemTravelBelt();
	public static final Item knockbackBelt = new ItemKnockbackBelt();
	public static final Item icePendant = new ItemIcePendant();
	public static final Item lavaPendant = new ItemLavaPendant();
	public static final Item magnetRing = new ItemMagnetRing();
	public static final Item waterRing = new ItemWaterRing();
	public static final Item miningRing = new ItemMiningRing();
	public static final Item terraPick = new ItemTerraPick();
	public static final Item divaCharm = new ItemDivaCharm();
	public static final Item flightTiara = new ItemFlightTiara();
	public static final Item enderDagger = new ItemEnderDagger();
	public static final Item quartz = new ItemQuartz();
	public static final Item waterRod = new ItemWaterRod();
	public static final Item elementiumHelm = new ItemElementiumHelm();
	public static final Item elementiumHelmRevealing = new ItemElementiumHelmRevealing();
	public static final Item elementiumChest = new ItemElementiumChest();
	public static final Item elementiumLegs = new ItemElementiumLegs();
	public static final Item elementiumBoots = new ItemElementiumBoots();
	public static final Item elementiumPick = new ItemElementiumPick();
	public static final Item elementiumShovel = new ItemElementiumShovel();
	public static final Item elementiumAxe = new ItemElementiumAxe();
	public static final Item elementiumSword = new ItemElementiumSword();
	public static final Item elementiumShears = new ItemElementiumShears();
	public static final Item openBucket = new ItemOpenBucket();
	public static final Item spawnerMover = new ItemSpawnerMover();
	public static final Item pixieRing = new ItemPixieRing();
	public static final Item superTravelBelt = new ItemSuperTravelBelt();
	public static final Item rainbowRod = new ItemRainbowRod();
	public static final Item tornadoRod = new ItemTornadoRod();
	public static final Item fireRod = new ItemFireRod();
	public static final Item vineBall = new ItemVineBall();
	public static final Item slingshot = new ItemSlingshot();
	public static final Item manaBottle = new ItemBottledMana();
	public static final Item laputaShard = new ItemLaputaShard();
	public static final Item virus = new ItemVirus();
	public static final Item reachRing = new ItemReachRing();
	public static final Item skyDirtRod = new ItemSkyDirtRod();
	public static final Item itemFinder = new ItemItemFinder();
	public static final Item superLavaPendant = new ItemSuperLavaPendant();
	public static final Item enderHand = new ItemEnderHand();
	public static final Item glassPick = new ItemGlassPick();
	public static final Item spark = new ItemSpark();
	public static final Item sparkUpgrade = new ItemSparkUpgrade();
	public static final Item diviningRod = new ItemDiviningRod();
	public static final Item gravityRod = new ItemGravityRod();
	public static final Item manaInkwell = new ItemManaInkwell();
	public static final Item vial = new ItemVial();
	public static final Item brewVial = new ItemBrewVial();
	public static final Item brewFlask = new ItemBrewFlask();
	public static final Item bloodPendant = new ItemBloodPendant();
	public static final Item missileRod = new ItemMissileRod();
	public static final Item holyCloak = new ItemHolyCloak();
	public static final Item unholyCloak = new ItemUnholyCloak();
	public static final Item balanceCloak = new ItemBalanceCloak();
	public static final Item craftingHalo = new ItemCraftingHalo();
	public static final Item blackLotus = new ItemBlackLotus();
	public static final Item monocle = new ItemMonocle();
	public static final Item clip = new ItemClip();
	public static final Item cobbleRod = new ItemCobbleRod();
	public static final Item smeltRod = new ItemSmeltRod();
	public static final Item worldSeed = new ItemWorldSeed();
	public static final Item spellCloth = new ItemSpellCloth();
	public static final Item thornChakram = new ItemThornChakram();
	public static final Item overgrowthSeed = new ItemOvergrowthSeed();
	public static final Item craftPattern = new ItemCraftPattern();
	public static final Item ancientWill = new ItemAncientWill();
	public static final Item corporeaSpark = new ItemCorporeaSpark();
	public static final Item livingwoodBow = new ItemLivingwoodBow();
	public static final Item crystalBow = new ItemCrystalBow();
	public static final Item cosmetic = new ItemBaubleCosmetic();
	public static final Item swapRing = new ItemSwapRing();
	public static final Item flowerBag = new ItemFlowerBag();
	public static final Item phantomInk = new ItemPhantomInk();
	public static final Item poolMinecart = new ItemPoolMinecart();
	public static final Item pinkinator = new ItemPinkinator();
	public static final Item infiniteFruit = new ItemInfiniteFruit();
	public static final Item kingKey = new ItemKingKey();
	public static final Item flugelEye = new ItemFlugelEye();
	public static final Item thorRing = new ItemThorRing();
	public static final Item odinRing = new ItemOdinRing();
	public static final Item lokiRing = new ItemLokiRing();
	public static final Item dice = new ItemDice();
	public static final Item keepIvy = new ItemKeepIvy();
	public static final Item blackHoleTalisman = new ItemBlackHoleTalisman();
	public static final Item recordGaia1 = new ItemRecordGaia1();
	public static final Item recordGaia2 = new ItemRecordGaia2();
	public static final Item temperanceStone = new ItemTemperanceStone();
	public static final Item incenseStick = new ItemIncenseStick();
	public static final Item terraAxe = new ItemTerraAxe();
	public static final Item waterBowl = new ItemWaterBowl();
	public static final Item obedienceStick = new ItemObedienceStick();
	public static final Item cacophonium = new ItemCacophonium();
	public static final Item slimeBottle = new ItemSlimeBottle();
	public static final Item starSword = new ItemStarSword();
	public static final Item exchangeRod = new ItemExchangeRod();
	public static final Item magnetRingGreater = new ItemGreaterMagnetRing();
	public static final Item thunderSword = new ItemThunderSword();
	public static final Item manaweaveHelm = new ItemManaweaveHelm();
	public static final Item manaweaveChest = new ItemManaweaveChest();
	public static final Item manaweaveLegs = new ItemManaweaveLegs();
	public static final Item manaweaveBoots = new ItemManaweaveBoots();
	public static final Item autocraftingHalo = new ItemAutocraftingHalo();
	public static final Item gaiaHead = new ItemGaiaHead();
	public static final Item sextant = new ItemSextant();
	public static final Item speedUpBelt = new ItemSpeedUpBelt();
	public static final Item baubleBox = new ItemBaubleBox();
	public static final Item dodgeRing = new ItemDodgeRing();
	public static final Item invisibilityCloak = new ItemInvisibilityCloak();
	public static final Item cloudPendant = new ItemCloudPendant();
	public static final Item superCloudPendant = new ItemSuperCloudPendant();
	public static final Item thirdEye = new ItemThirdEye();
	public static final Item astrolabe = new ItemAstrolabe();
	public static final Item goddessCharm = new ItemGoddessCharm();

	@SubscribeEvent
	public static void registerItems(RegistryEvent.Register<Item> evt) {
		IForgeRegistry<Item> r = evt.getRegistry();

		r.register(lexicon);
		r.register(petal);
		r.register(dye);
		r.register(pestleAndMortar);
		r.register(twigWand);
		r.register(manaResource);
		r.register(lens);
		r.register(rune);
		r.register(manaTablet);
		r.register(manaGun);
		r.register(manaCookie);
		r.register(fertilizer);
		r.register(grassSeeds);
		r.register(dirtRod);
		r.register(terraformRod);
		r.register(grassHorn);
		r.register(manaMirror);
		r.register(manasteelHelm);
		r.register(manasteelHelmRevealing);
		r.register(manasteelChest);
		r.register(manasteelLegs);
		r.register(manasteelBoots);
		r.register(manasteelPick);
		r.register(manasteelShovel);
		r.register(manasteelAxe);
		r.register(manasteelSword);
		r.register(manasteelShears);
		r.register(terrasteelHelm);
		r.register(terrasteelHelmRevealing);
		r.register(terrasteelChest);
		r.register(terrasteelLegs);
		r.register(terrasteelBoots);
		r.register(terraSword);
		r.register(tinyPlanet);
		r.register(manaRing);
		r.register(auraRing);
		r.register(manaRingGreater);
		r.register(auraRingGreater);
		r.register(travelBelt);
		r.register(knockbackBelt);
		r.register(icePendant);
		r.register(lavaPendant);
		r.register(magnetRing);
		r.register(waterRing);
		r.register(miningRing);
		r.register(terraPick);
		r.register(divaCharm);
		r.register(flightTiara);
		r.register(enderDagger);
		r.register(quartz);
		r.register(waterRod);
		r.register(elementiumHelm);
		r.register(elementiumHelmRevealing);
		r.register(elementiumChest);
		r.register(elementiumLegs);
		r.register(elementiumBoots);
		r.register(elementiumPick);
		r.register(elementiumShovel);
		r.register(elementiumAxe);
		r.register(elementiumSword);
		r.register(elementiumShears);
		r.register(openBucket);
		r.register(spawnerMover);
		r.register(pixieRing);
		r.register(superTravelBelt);
		r.register(rainbowRod);
		r.register(tornadoRod);
		r.register(fireRod);
		r.register(vineBall);
		r.register(slingshot);
		r.register(manaBottle);
		r.register(laputaShard);
		r.register(virus);
		r.register(reachRing);
		r.register(skyDirtRod);
		r.register(itemFinder);
		r.register(superLavaPendant);
		r.register(enderHand);
		r.register(glassPick);
		r.register(spark);
		r.register(sparkUpgrade);
		r.register(diviningRod);
		r.register(gravityRod);
		r.register(manaInkwell);
		r.register(vial);
		r.register(brewVial);
		r.register(brewFlask);
		r.register(bloodPendant);
		r.register(missileRod);
		r.register(holyCloak);
		r.register(unholyCloak);
		r.register(balanceCloak);
		r.register(craftingHalo);
		r.register(blackLotus);
		r.register(monocle);
		r.register(clip);
		r.register(cobbleRod);
		r.register(smeltRod);
		r.register(worldSeed);
		r.register(spellCloth);
		r.register(thornChakram);
		r.register(overgrowthSeed);
		r.register(craftPattern);
		r.register(ancientWill);
		r.register(corporeaSpark);
		r.register(livingwoodBow);
		r.register(crystalBow);
		r.register(cosmetic);
		r.register(swapRing);
		r.register(flowerBag);
		r.register(phantomInk);
		r.register(poolMinecart);
		r.register(pinkinator);
		r.register(infiniteFruit);
		r.register(kingKey);
		r.register(flugelEye);
		r.register(thorRing);
		r.register(odinRing);
		r.register(lokiRing);
		r.register(dice);
		r.register(keepIvy);
		r.register(blackHoleTalisman);
		r.register(recordGaia1);
		r.register(recordGaia2);
		r.register(temperanceStone);
		r.register(incenseStick);
		r.register(terraAxe);
		r.register(waterBowl);
		r.register(obedienceStick);
		r.register(cacophonium);
		r.register(slimeBottle);
		r.register(starSword);
		r.register(exchangeRod);
		r.register(magnetRingGreater);
		r.register(thunderSword);
		r.register(manaweaveHelm);
		r.register(manaweaveChest);
		r.register(manaweaveLegs);
		r.register(manaweaveBoots);
		r.register(autocraftingHalo);
		r.register(gaiaHead);
		r.register(sextant);
		r.register(speedUpBelt);
		r.register(baubleBox);
		r.register(dodgeRing);
		r.register(invisibilityCloak);
		r.register(cloudPendant);
		r.register(superCloudPendant);
		r.register(thirdEye);
		r.register(astrolabe);
		r.register(goddessCharm);

		registerOreDictionary();
	}
	
	private static void registerOreDictionary() {
		OreDictionary.registerOre(LibOreDict.LEXICON, lexicon);
		for(int i = 0; i < 16; i++) {
			OreDictionary.registerOre(LibOreDict.PETAL[i], new ItemStack(petal, 1, i));
			OreDictionary.registerOre(LibOreDict.DYE[i], new ItemStack(dye, 1, i));
			OreDictionary.registerOre(LibOreDict.RUNE[i], new ItemStack(rune, 1, i));
		}
		OreDictionary.registerOre(LibOreDict.DYE_WILDCARD, new ItemStack(dye, 1, OreDictionary.WILDCARD_VALUE));
		for(int i = 0; i < 7; i++)
			OreDictionary.registerOre(LibOreDict.QUARTZ[i], new ItemStack(quartz, 1, i));

		OreDictionary.registerOre(LibOreDict.PESTLE_AND_MORTAR, pestleAndMortar);
		OreDictionary.registerOre(LibOreDict.MANA_STEEL, new ItemStack(manaResource, 1, 0));
		OreDictionary.registerOre(LibOreDict.MANA_PEARL, new ItemStack(manaResource, 1, 1));
		OreDictionary.registerOre(LibOreDict.MANA_DIAMOND, new ItemStack(manaResource, 1, 2));
		OreDictionary.registerOre(LibOreDict.LIVINGWOOD_TWIG, new ItemStack(manaResource, 1, 3));
		OreDictionary.registerOre(LibOreDict.TERRA_STEEL, new ItemStack(manaResource, 1, 4));
		OreDictionary.registerOre(LibOreDict.LIFE_ESSENCE, new ItemStack(manaResource, 1, 5));
		OreDictionary.registerOre(LibOreDict.REDSTONE_ROOT, new ItemStack(manaResource, 1, 6));
		OreDictionary.registerOre(LibOreDict.ELEMENTIUM, new ItemStack(manaResource, 1, 7));
		OreDictionary.registerOre(LibOreDict.PIXIE_DUST, new ItemStack(manaResource, 1, 8));
		OreDictionary.registerOre(LibOreDict.DRAGONSTONE, new ItemStack(manaResource, 1, 9));
		OreDictionary.registerOre(LibOreDict.PLACEHOLDER, new ItemStack(manaResource, 1, 11));
		OreDictionary.registerOre(LibOreDict.RED_STRING, new ItemStack(manaResource, 1, 12));
		OreDictionary.registerOre(LibOreDict.DREAMWOOD_TWIG, new ItemStack(manaResource, 1, 13));
		OreDictionary.registerOre(LibOreDict.GAIA_INGOT, new ItemStack(manaResource, 1, 14));
		OreDictionary.registerOre(LibOreDict.ENDER_AIR_BOTTLE, new ItemStack(manaResource, 1, 15));
		OreDictionary.registerOre(LibOreDict.MANA_STRING, new ItemStack(manaResource, 1, 16));
		OreDictionary.registerOre(LibOreDict.MANASTEEL_NUGGET, new ItemStack(manaResource, 1, 17));
		OreDictionary.registerOre(LibOreDict.TERRASTEEL_NUGGET, new ItemStack(manaResource, 1, 18));
		OreDictionary.registerOre(LibOreDict.ELEMENTIUM_NUGGET, new ItemStack(manaResource, 1, 19));
		OreDictionary.registerOre(LibOreDict.ROOT, new ItemStack(manaResource, 1, 20));
		OreDictionary.registerOre(LibOreDict.PEBBLE, new ItemStack(manaResource, 1, 21));
		OreDictionary.registerOre(LibOreDict.MANAWEAVE_CLOTH, new ItemStack(manaResource, 1, 22));
		OreDictionary.registerOre(LibOreDict.MANA_POWDER, new ItemStack(manaResource, 1, 23));

		OreDictionary.registerOre(LibOreDict.VIAL, new ItemStack(vial, 1, 0));
		OreDictionary.registerOre(LibOreDict.FLASK, new ItemStack(vial, 1, 1));

		BotaniaAPI.blackListItemFromLoonium(lexicon);
		BotaniaAPI.blackListItemFromLoonium(overgrowthSeed);
		BotaniaAPI.blackListItemFromLoonium(blackLotus);
		int min = Item.getIdFromItem(Items.RECORD_13);
		int max = Item.getIdFromItem(Items.RECORD_WAIT);
		for(int i = min; i <= max; i++)
			BotaniaAPI.blackListItemFromLoonium(Item.getItemById(i));

		OreDictionary.registerOre("rodBlaze", Items.BLAZE_ROD);
		OreDictionary.registerOre("powderBlaze", Items.BLAZE_POWDER);
	}
}
