/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class ElvenTradeProvider
extends BotaniaRecipeProvider {
    public ElvenTradeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public void buildRecipes(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dreamwood_log"), new ItemStack((ItemLike)BotaniaBlocks.dreamwoodLog), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.livingwoodLog})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dreamwood"), new ItemStack((ItemLike)BotaniaBlocks.dreamwood), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.livingwood})));
        Ingredient manaDiamond = Ingredient.of(BotaniaTags.Items.GEMS_MANA_DIAMOND);
        Ingredient manaSteel = Ingredient.of(BotaniaTags.Items.INGOTS_MANASTEEL);
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elementium"), new ItemStack((ItemLike)BotaniaItems.elementium), manaSteel, manaSteel));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elementium_block"), new ItemStack((ItemLike)BotaniaBlocks.elementiumBlock), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manasteelBlock}), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manasteelBlock})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("pixie_dust"), new ItemStack((ItemLike)BotaniaItems.pixieDust), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dragonstone"), new ItemStack((ItemLike)BotaniaItems.dragonstone), manaDiamond));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dragonstone_block"), new ItemStack((ItemLike)BotaniaBlocks.dragonstoneBlock), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manaDiamondBlock})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elf_quartz"), new ItemStack((ItemLike)BotaniaItems.elfQuartz), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elf_glass"), new ItemStack((ItemLike)BotaniaBlocks.elfGlass), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manaGlass})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("iron_return"), new ItemStack((ItemLike)Items.IRON_INGOT), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("iron_block_return"), new ItemStack((ItemLike)Blocks.IRON_BLOCK), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.IRON_BLOCK})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("ender_pearl_return"), new ItemStack((ItemLike)Items.ENDER_PEARL), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("diamond_return"), new ItemStack((ItemLike)Items.DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("diamond_block_return"), new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DIAMOND_BLOCK})));
        consumer.accept(new FinishedRecipe(){

            public void serializeRecipeData(JsonObject obj) {
            }

            public ResourceLocation getId() {
                return ElvenTradeProvider.id("lexicon_elven");
            }

            public RecipeSerializer<?> getType() {
                return BotaniaRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER;
            }

            @Nullable
            public JsonObject serializeAdvancement() {
                return null;
            }

            @Nullable
            public ResourceLocation getAdvancementId() {
                return null;
            }
        });
    }

    private static ResourceLocation id(String path) {
        return ResourceLocationHelper.prefix("elven_trade/" + path);
    }

    public String getName() {
        return "Botania elven trade recipes";
    }

    protected static class FinishedElvenRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> inputs;
        private final List<ItemStack> outputs;

        public FinishedElvenRecipe(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
            this(id, Arrays.asList(inputs), Collections.singletonList(output));
        }

        protected FinishedElvenRecipe(ResourceLocation id, List<Ingredient> inputs, List<ItemStack> outputs) {
            this.id = id;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public void serializeRecipeData(JsonObject json) {
            JsonArray in = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                in.add(ingr.toJson());
            }
            JsonArray out = new JsonArray();
            for (ItemStack s : this.outputs) {
                out.add((JsonElement)ItemNBTHelper.serializeStack(s));
            }
            json.add("ingredients", (JsonElement)in);
            json.add("output", (JsonElement)out);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.ELVEN_TRADE_SERIALIZER;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }
}

