/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.world.MysticalFlowerConfig;

public class MysticalFlowerFeature
extends Feature<MysticalFlowerConfig> {
    public MysticalFlowerFeature(Codec<MysticalFlowerConfig> codec) {
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<MysticalFlowerConfig> ctx) {
        MysticalFlowerConfig config = (MysticalFlowerConfig)ctx.config();
        WorldGenLevel level = ctx.level();
        BlockPos pos = ctx.origin();
        BlockState state = config.toPlace().getState(ctx.random(), pos);
        if (state.canSurvive((LevelReader)level, pos)) {
            if (state.getBlock().getClass() == BotaniaFlowerBlock.class && ctx.random().nextFloat() < config.tallChance()) {
                if (!level.isEmptyBlock(pos.above())) {
                    return false;
                }
                DyeColor color = ((BotaniaFlowerBlock)state.getBlock()).color;
                Block doubleFlower = BotaniaBlocks.getDoubleFlower(color);
                DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)doubleFlower.defaultBlockState(), (BlockPos)pos, (int)2);
            } else {
                level.setBlock(pos, state, 2);
            }
            return true;
        }
        return false;
    }
}

