/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.item.WireframeCoordinateListProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.CollectingNeighborUpdaterAccess;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.mixin.LevelAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class ShiftingCrustRodItem
extends Item
implements WireframeCoordinateListProvider {
    private static final int RANGE = 3;
    private static final int COST = 40;
    private static final String TAG_REPLACEMENT_ITEM = "placedItem";
    private static final String TAG_TARGET_BLOCK_NAME = "targetBlock";
    private static final String TAG_SWAPPING = "swapping";
    private static final String TAG_SELECT_X = "selectX";
    private static final String TAG_SELECT_Y = "selectY";
    private static final String TAG_SELECT_Z = "selectZ";
    private static final String TAG_EXTRA_RANGE = "extraRange";
    private static final String TAG_SWAP_HIT_VEC = "swapHitVec";
    private static final String TAG_SWAP_DIRECTION = "swapDirection";
    private static final String TAG_SWAP_CLICKED_AXIS = "swapClickAxis";
    private static final String TAG_TEMPERANCE_STONE = "temperanceStone";

    public ShiftingCrustRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Item replacement;
        List<BlockPos> swap;
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        BlockState wstate = world.getBlockState(pos);
        Block block = wstate.getBlock();
        if (player != null && player.isSecondaryUseActive()) {
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile == null && block.asItem() != Items.AIR && (wstate.isSolidRender((BlockGetter)world, pos) || wstate.getRenderShape() == RenderShape.MODEL) && (wstate.canOcclude() || block instanceof AbstractGlassBlock || block instanceof IronBarsBlock) && block.asItem() instanceof BlockItem) {
                this.setItemToPlace(stack, block.asItem());
                this.setSwapTemplateDirection(stack, ctx.getClickedFace());
                this.setHitPos(stack, ctx.getClickLocation());
                this.displayRemainderCounter(player, stack);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
        } else if (this.canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false) && (swap = this.getTargetPositions(world, stack, replacement = this.getItemToPlace(stack), pos, block, ctx.getClickedFace())).size() > 0) {
            ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
            ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.getX());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.getY());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.getZ());
            this.setSwapClickDirection(stack, ctx.getClickedFace());
            this.setTarget(stack, block);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide());
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public InteractionResult onLeftClick(Player player, Level world, InteractionHand hand, BlockPos pos, Direction side) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && stack.is((Item)this)) {
            int exchange;
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (this.canExchange(stack) && ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false) && (exchange = this.exchange(world, player, pos, stack, this.getItemToPlace(stack))) > 0) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, exchange, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean equipped) {
        boolean temperanceActive;
        int extraRangeNew;
        if (!this.canExchange(stack) || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
        int n = extraRangeNew = ManaItemHandler.instance().hasProficiency(player, stack) ? 3 : 1;
        if (extraRange != extraRangeNew) {
            ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
        }
        if ((temperanceActive = StoneOfTemperanceItem.hasTemperanceActive(player)) != stack.getOrCreateTag().getBoolean(TAG_TEMPERANCE_STONE)) {
            stack.getOrCreateTag().putBoolean(TAG_TEMPERANCE_STONE, temperanceActive);
        }
        Item replacement = this.getItemToPlace(stack);
        if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
            Block target;
            int z;
            int y;
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false)) {
                ShiftingCrustRodItem.endSwapping(stack);
                return;
            }
            int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
            List<BlockPos> swap = this.getTargetPositions(world, stack, replacement, new BlockPos(x, y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0)), target = ShiftingCrustRodItem.getTargetState(stack), this.getSwapClickDirection(stack));
            if (swap.size() == 0) {
                ShiftingCrustRodItem.endSwapping(stack);
                return;
            }
            BlockPos coords = swap.get(world.random.nextInt(swap.size()));
            int exchange = this.exchange(world, player, coords, stack, replacement);
            if (exchange > 0) {
                ManaItemHandler.instance().requestManaForTool(stack, player, exchange, true);
            } else {
                ShiftingCrustRodItem.endSwapping(stack);
            }
        }
    }

    public List<BlockPos> getTargetPositions(Level world, ItemStack stack, Item toPlace, BlockPos pos, Block toReplace, Direction clickedSide) {
        ArrayList<BlockPos> coordsList = new ArrayList<BlockPos>();
        Direction.Axis axis = clickedSide.getAxis();
        int xRange = this.getRange(stack, axis, Direction.Axis.X);
        int yRange = this.getRange(stack, axis, Direction.Axis.Y);
        int zRange = this.getRange(stack, axis, Direction.Axis.Z);
        for (int offsetX = -xRange; offsetX <= xRange; ++offsetX) {
            for (int offsetY = -yRange; offsetY <= yRange; ++offsetY) {
                block2: for (int offsetZ = -zRange; offsetZ <= zRange; ++offsetZ) {
                    BlockPos pos_ = pos.offset(offsetX, offsetY, offsetZ);
                    BlockState currentState = world.getBlockState(pos_);
                    if (!currentState.is(toReplace) || currentState.getBlock().asItem() == toPlace) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos adjPos = pos_.relative(dir);
                        BlockState adjState = world.getBlockState(adjPos);
                        if (Block.isFaceFull((VoxelShape)adjState.getBlockSupportShape((BlockGetter)world, pos), (Direction)dir.getOpposite())) continue;
                        coordsList.add(pos_);
                        continue block2;
                    }
                }
            }
        }
        return coordsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exchange(Level world, Player player, BlockPos pos, ItemStack rod, Item replacement) {
        BlockState stateAt;
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null) {
            return 0;
        }
        ItemStack placeStack = ShiftingCrustRodItem.removeFromInventory(player, rod, replacement, false);
        if (!placeStack.isEmpty() && !(stateAt = world.getBlockState(pos)).isAir() && stateAt.getDestroyProgress(player, (BlockGetter)world, pos) > 0.0f && stateAt.getBlock().asItem() != replacement) {
            float hardness = stateAt.getDestroySpeed((BlockGetter)world, pos);
            if (!world.isClientSide) {
                CollectingNeighborUpdaterAccess access;
                NeighborUpdater neighborUpdater = ((LevelAccessor)world).getNeighborUpdater();
                try {
                    if (neighborUpdater instanceof CollectingNeighborUpdaterAccess) {
                        access = (CollectingNeighborUpdaterAccess)neighborUpdater;
                        access.botania$pauseUpdates();
                    }
                    world.destroyBlock(pos, !player.getAbilities().instabuild, (Entity)player);
                    BlockHitResult hit = new BlockHitResult(this.getHitPos(rod, pos), this.getSwapTemplateDirection(rod), pos, false);
                    InteractionResult result = PlayerHelper.substituteUse(new UseOnContext(player, InteractionHand.MAIN_HAND, hit), placeStack);
                    if (!player.getAbilities().instabuild) {
                        if (result.consumesAction()) {
                            ShiftingCrustRodItem.removeFromInventory(player, rod, replacement, true);
                            this.displayRemainderCounter(player, rod);
                        } else {
                            ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 2, 0.1, 0.1, 0.1, 0.0);
                        }
                    }
                }
                finally {
                    if (neighborUpdater instanceof CollectingNeighborUpdaterAccess) {
                        access = (CollectingNeighborUpdaterAccess)neighborUpdater;
                        access.botania$resumeUpdates();
                    }
                }
            }
            return hardness <= 10.0f ? 40 : (int)(20.0 + (double)(3.0f * hardness));
        }
        return 0;
    }

    public boolean canExchange(ItemStack stack) {
        return this.getItemToPlace(stack) != Items.AIR;
    }

    public static ItemStack removeFromInventory(Player player, Container inv, ItemStack tool, Item requested, boolean doit) {
        ArrayList<BlockProvider> providers = new ArrayList<BlockProvider>();
        for (int i = inv.getContainerSize() - 1; i >= 0; --i) {
            ItemStack invStack = inv.getItem(i);
            if (invStack.isEmpty()) continue;
            Item item = invStack.getItem();
            if (item == requested) {
                ItemStack ret = doit ? inv.removeItem(i, 1) : invStack.copyWithCount(1);
                return ret;
            }
            BlockProvider provider = XplatAbstractions.INSTANCE.findBlockProvider(invStack);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (requested instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)requested;
            Block block = blockItem.getBlock();
            for (BlockProvider prov : providers) {
                if (!prov.provideBlock(player, tool, block, doit)) continue;
                return new ItemStack((ItemLike)requested);
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack removeFromInventory(Player player, ItemStack tool, Item item, boolean doit) {
        if (player.getAbilities().instabuild) {
            return new ItemStack((ItemLike)item);
        }
        ItemStack outStack = ShiftingCrustRodItem.removeFromInventory(player, BotaniaAPI.instance().getAccessoriesInventory(player), tool, item, doit);
        if (outStack.isEmpty()) {
            outStack = ShiftingCrustRodItem.removeFromInventory(player, (Container)player.getInventory(), tool, item, doit);
        }
        return outStack;
    }

    public static int getInventoryItemCount(Player player, ItemStack stack, Item item) {
        if (player.getAbilities().instabuild) {
            return -1;
        }
        int baubleCount = ShiftingCrustRodItem.getInventoryItemCount(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, item);
        if (baubleCount == -1) {
            return -1;
        }
        int count = ShiftingCrustRodItem.getInventoryItemCount(player, (Container)player.getInventory(), stack, item);
        if (count == -1) {
            return -1;
        }
        return count + baubleCount;
    }

    public static int getInventoryItemCount(Player player, Container inv, ItemStack stack, Item requested) {
        if (player.getAbilities().instabuild) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            BlockProvider prov;
            ItemStack invStack = inv.getItem(i);
            if (invStack.isEmpty()) continue;
            Item item = invStack.getItem();
            if (item == requested.asItem()) {
                count += invStack.getCount();
            }
            if ((prov = XplatAbstractions.INSTANCE.findBlockProvider(invStack)) == null || !(requested instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)requested;
            int provCount = prov.getBlockCount(player, stack, blockItem.getBlock());
            if (provCount == -1) {
                return -1;
            }
            count += provCount;
        }
        return count;
    }

    public void displayRemainderCounter(Player player, ItemStack stack) {
        if (!player.level().isClientSide) {
            Item item = this.getItemToPlace(stack);
            int count = ShiftingCrustRodItem.getInventoryItemCount(player, stack, item);
            ItemsRemainingRenderHandler.send(player, new ItemStack((ItemLike)item), count);
        }
    }

    private void setItemToPlace(ItemStack stack, Item item) {
        ItemNBTHelper.setString(stack, TAG_REPLACEMENT_ITEM, BuiltInRegistries.ITEM.getKey((Object)item).toString());
    }

    private Item getItemToPlace(ItemStack stack) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)ItemNBTHelper.getString(stack, TAG_REPLACEMENT_ITEM, "air")));
    }

    private void setHitPos(ItemStack stack, Vec3 vec) {
        ListTag list = new ListTag();
        list.add((Object)DoubleTag.valueOf((double)Mth.frac((double)vec.x())));
        list.add((Object)DoubleTag.valueOf((double)Mth.frac((double)vec.y())));
        list.add((Object)DoubleTag.valueOf((double)Mth.frac((double)vec.z())));
        stack.getOrCreateTag().put(TAG_SWAP_HIT_VEC, (Tag)list);
    }

    private Vec3 getHitPos(ItemStack stack, BlockPos pos) {
        ListTag list = stack.getOrCreateTag().getList(TAG_SWAP_HIT_VEC, 6);
        return new Vec3((double)pos.getX() + list.getDouble(0), (double)pos.getY() + list.getDouble(1), (double)pos.getZ() + list.getDouble(2));
    }

    private void setSwapTemplateDirection(ItemStack stack, Direction direction) {
        stack.getOrCreateTag().putInt(TAG_SWAP_DIRECTION, direction.get3DDataValue());
    }

    private Direction getSwapTemplateDirection(ItemStack stack) {
        return Direction.from3DDataValue((int)stack.getOrCreateTag().getInt(TAG_SWAP_DIRECTION));
    }

    private void setSwapClickDirection(ItemStack stack, Direction direction) {
        stack.getOrCreateTag().putInt(TAG_SWAP_CLICKED_AXIS, direction.get3DDataValue());
    }

    private Direction getSwapClickDirection(ItemStack stack) {
        return Direction.from3DDataValue((int)stack.getOrCreateTag().getInt(TAG_SWAP_CLICKED_AXIS));
    }

    private int getRange(ItemStack stack, Direction.Axis clickAxis, Direction.Axis rangeAxis) {
        if (stack.getOrCreateTag().getBoolean(TAG_TEMPERANCE_STONE) && rangeAxis == clickAxis) {
            return 0;
        }
        return 3 + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;
    }

    private static void endSwapping(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_X);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Y);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Z);
        ItemNBTHelper.removeEntry(stack, TAG_TARGET_BLOCK_NAME);
        ItemNBTHelper.removeEntry(stack, TAG_SWAP_CLICKED_AXIS);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Item item = this.getItemToPlace(stack);
        MutableComponent cmp = super.getName(stack).copy();
        if (item != Items.AIR) {
            cmp.append(" (");
            Component sub = new ItemStack((ItemLike)item).getHoverName();
            cmp.append((Component)sub.copy().withStyle(ChatFormatting.GREEN));
            cmp.append(")");
        }
        return cmp;
    }

    private void setTarget(ItemStack stack, Block block) {
        ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, BuiltInRegistries.BLOCK.getKey((Object)block).toString());
    }

    public static Block getTargetState(ItemStack stack) {
        ResourceLocation id = new ResourceLocation(ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "minecraft:air"));
        return (Block)BuiltInRegistries.BLOCK.get(id);
    }

    @Override
    public List<BlockPos> getWireframesToDraw(Player player, ItemStack stack) {
        ItemStack holding = player.getMainHandItem();
        if (holding != stack || !this.canExchange(stack)) {
            return ImmutableList.of();
        }
        HitResult pos = Minecraft.getInstance().hitResult;
        if (pos != null && pos.getType() == HitResult.Type.BLOCK) {
            BlockPos bPos = ((BlockHitResult)pos).getBlockPos();
            Block target = Minecraft.getInstance().level.getBlockState(bPos).getBlock();
            if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
                bPos = new BlockPos(ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0));
                target = ShiftingCrustRodItem.getTargetState(stack);
            }
            if (!player.level().isEmptyBlock(bPos)) {
                Item item = this.getItemToPlace(stack);
                List<BlockPos> coordsList = this.getTargetPositions(player.level(), stack, item, bPos, target, ((BlockHitResult)pos).getDirection());
                coordsList.removeIf(arg_0 -> ((BlockPos)bPos).equals(arg_0));
                return coordsList;
            }
        }
        return ImmutableList.of();
    }
}

