/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BifrostBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.material.SelfReturningItem;
import vazkii.botania.xplat.XplatAbstractions;

public class BifrostRodItem
extends SelfReturningItem {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_rainbow.png");
    private static final int MANA_COST = 750;
    private static final int MANA_COST_AVATAR = 4;
    private static final int TIME = 600;

    public BifrostRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, false)) {
            BlockState bifrost = BotaniaBlocks.bifrost.defaultBlockState();
            Vec3 vector = player.getLookAngle().normalize();
            double x = player.getX();
            double y = player.getY() - 1.0;
            double z = player.getZ();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((int)x, (int)y, (int)z);
            double lastX = 0.0;
            double lastY = -1.0;
            double lastZ = 0.0;
            BlockPos.MutableBlockPos previousPos = new BlockPos.MutableBlockPos();
            boolean placedAny = false;
            boolean prof = ManaItemHandler.instance().hasProficiency(player, stack);
            int maxlen = prof ? 160 : 100;
            int time = prof ? 960 : 600;
            BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
            for (int count = 0; count < maxlen; ++count) {
                previousPos.set(lastX, lastY, lastZ);
                if (!previousPos.equals((Object)pos)) {
                    if (!world.isEmptyBlock((BlockPos)pos) && world.getBlockState((BlockPos)pos) != bifrost && count >= 4 || world.isOutsideBuildHeight(pos.getY())) break;
                    if (BifrostRodItem.placeBridgeSegment(world, (BlockPos)pos, placePos, time)) {
                        placedAny = true;
                    }
                }
                lastX = x;
                lastY = y;
                lastZ = z;
                pos.set(x += vector.x, y += vector.y, z += vector.z);
            }
            if (placedAny) {
                world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.bifrostRod, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, false);
                player.getCooldowns().addCooldown((Item)this, player.isCreative() ? 10 : 600);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    private static boolean placeBridgeSegment(Level world, BlockPos center, BlockPos.MutableBlockPos placePos, int time) {
        BlockState bifrost = BotaniaBlocks.bifrost.defaultBlockState();
        boolean placed = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                placePos.set(center.getX() + i, center.getY(), center.getZ() + j);
                if (!world.isEmptyBlock((BlockPos)placePos) && world.getBlockState((BlockPos)placePos) != bifrost) continue;
                world.setBlock((BlockPos)placePos, bifrost, 2);
                BifrostBlockEntity tile = (BifrostBlockEntity)world.getBlockEntity((BlockPos)placePos);
                if (tile == null) continue;
                tile.ticks = time;
                placed = true;
            }
        }
        return placed;
    }

    public static class AvatarBehavior
    implements AvatarWieldable {
        @Override
        public void onAvatarUpdate(Avatar tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.getLevel();
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.getBlockPos(), te.getBlockState(), te, null);
            if (world.isClientSide || receiver.getCurrentMana() < 100 || !tile.isEnabled() || world.isOutsideBuildHeight(te.getBlockPos().getY() - 1)) {
                return;
            }
            BlockPos tePos = te.getBlockPos();
            int w = 1;
            int h = 1;
            int l = 20;
            AABB axis = null;
            switch ((Direction)world.getBlockState(tePos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case NORTH: {
                    axis = new AABB(tePos.offset(-w, -h, -l), tePos.offset(w + 1, h, 0));
                    break;
                }
                case SOUTH: {
                    axis = new AABB(tePos.offset(-w, -h, 1), tePos.offset(w + 1, h, l + 1));
                    break;
                }
                case WEST: {
                    axis = new AABB(tePos.offset(-l, -h, -w), tePos.offset(0, h, w + 1));
                    break;
                }
                case EAST: {
                    axis = new AABB(tePos.offset(1, -h, -w), tePos.offset(l + 1, h, w + 1));
                    break;
                }
            }
            List players = world.getEntitiesOfClass(Player.class, axis);
            for (Player p : players) {
                int px = Mth.floor((double)p.getX());
                int py = Mth.floor((double)p.getY()) - 1;
                int pz = Mth.floor((double)p.getZ());
                int dist = 5;
                int diff = dist / 2;
                for (int i = 0; i < dist; ++i) {
                    for (int j = 0; j < dist; ++j) {
                        BifrostBlockEntity bifrostBlockEntity;
                        int ex = px + i - diff;
                        int ez = pz + j - diff;
                        if (!axis.contains(new Vec3((double)ex + 0.5, (double)(py + 1), (double)ez + 0.5))) continue;
                        BlockPos pos = new BlockPos(ex, py, ez);
                        BlockState state = world.getBlockState(pos);
                        if (state.isAir()) {
                            if (!world.setBlockAndUpdate(pos, BotaniaBlocks.bifrost.defaultBlockState())) continue;
                            bifrostBlockEntity = (BifrostBlockEntity)world.getBlockEntity(pos);
                            bifrostBlockEntity.ticks = 10;
                            receiver.receiveMana(-4);
                            continue;
                        }
                        if (!state.is(BotaniaBlocks.bifrost)) continue;
                        bifrostBlockEntity = (BifrostBlockEntity)world.getBlockEntity(pos);
                        if (bifrostBlockEntity.ticks >= 2) continue;
                        bifrostBlockEntity.ticks += 10;
                        receiver.receiveMana(-4);
                    }
                }
            }
        }

        @Override
        public ResourceLocation getOverlayResource(Avatar tile) {
            return avatarOverlay;
        }
    }
}

