/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class EyeOfTheFlugelItem
extends RelicItem {
    private static final String TAG_TARGET_PREFIX = "target_";

    public EyeOfTheFlugelItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        if (player != null && player.isSecondaryUseActive()) {
            if (world.isClientSide) {
                for (int i = 0; i < 10; ++i) {
                    float x1 = (float)((double)pos.getX() + Math.random());
                    float y1 = pos.getY() + 1;
                    float z1 = (float)((double)pos.getZ() + Math.random());
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.5f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                    world.addParticle((ParticleOptions)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(0.05f - (float)Math.random() * 0.05f), 0.0);
                }
            } else {
                ItemStack stack = ctx.getItemInHand();
                Tag nbt = (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)pos).get().orThrow();
                ItemNBTHelper.set(stack, TAG_TARGET_PREFIX + world.dimension().location(), nbt);
                world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.flugelEyeBind, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void onUseTick(Level world, LivingEntity living, ItemStack stack, int count) {
        if (world.isClientSide) {
            float x = (float)(living.getX() - Math.random() * (double)living.getBbWidth());
            float y = (float)(living.getY() + Math.random());
            float z = (float)(living.getZ() - Math.random() * (double)living.getBbWidth());
            WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.7f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
            world.addParticle((ParticleOptions)data, (double)x, (double)y, (double)z, 0.0, (double)(0.05f + (float)Math.random() * 0.05f), 0.0);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level world, LivingEntity living) {
        block6: {
            int z;
            int y;
            int x;
            block5: {
                String tag = TAG_TARGET_PREFIX + world.dimension().location();
                Tag nbt = ItemNBTHelper.get(stack, tag);
                if (nbt == null) {
                    return stack;
                }
                Optional maybeLoc = BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).result();
                if (!maybeLoc.isPresent()) {
                    ItemNBTHelper.removeEntry(stack, tag);
                    return stack;
                }
                BlockPos loc = (BlockPos)maybeLoc.get();
                x = loc.getX();
                y = loc.getY();
                z = loc.getZ();
                int cost = (int)(MathHelper.pointDistanceSpace((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, living.getX(), living.getY(), living.getZ()) * 10.0f);
                if (!(living instanceof Player)) break block5;
                Player player = (Player)living;
                if (!ManaItemHandler.instance().requestManaExact(stack, player, cost, true)) break block6;
            }
            EyeOfTheFlugelItem.moveParticlesAndSound((Entity)living);
            Vec3 sourcePos = living.position();
            living.teleportTo((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
            world.gameEvent((Entity)living, GameEvent.TELEPORT, sourcePos);
            EyeOfTheFlugelItem.moveParticlesAndSound((Entity)living);
        }
        return stack;
    }

    private static void moveParticlesAndSound(Entity entity) {
        XplatAbstractions.INSTANCE.sendToTracking(entity, new BotaniaEffectPacket(EffectType.FLUGEL_EFFECT, entity.getX(), entity.getY(), entity.getZ(), entity.getId()));
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), BotaniaSounds.flugelEyeTeleport, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public int getUseDuration(ItemStack stack) {
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flags) {
        super.appendHoverText(stack, world, tooltip, flags);
        if (world == null) {
            return;
        }
        CoordBoundItem coordBoundItem = XplatAbstractions.INSTANCE.findCoordBoundItem(stack);
        if (coordBoundItem == null) {
            return;
        }
        BlockPos binding = coordBoundItem.getBinding(world);
        MutableComponent worldText = Component.literal((String)world.dimension().location().toString()).withStyle(ChatFormatting.GREEN);
        if (binding == null) {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.flugelUnbound", (Object[])new Object[]{worldText}).withStyle(ChatFormatting.GRAY));
        } else {
            MutableComponent bindingText = Component.literal((String)"[").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)Integer.toString(binding.getX())).withStyle(ChatFormatting.GOLD)).append(", ").append((Component)Component.literal((String)Integer.toString(binding.getY())).withStyle(ChatFormatting.GOLD)).append(", ").append((Component)Component.literal((String)Integer.toString(binding.getZ())).withStyle(ChatFormatting.GOLD)).append("]");
            tooltip.add((Component)Component.translatable((String)"botaniamisc.flugelBound", (Object[])new Object[]{bindingText, worldText}).withStyle(ChatFormatting.GRAY));
        }
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("challenge/flugel_eye"));
    }

    public static class CoordBoundItemImpl
    implements CoordBoundItem {
        private final ItemStack stack;

        public CoordBoundItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public BlockPos getBinding(Level world) {
            String tag = EyeOfTheFlugelItem.TAG_TARGET_PREFIX + world.dimension().location();
            Tag nbt = ItemNBTHelper.get(this.stack, tag);
            if (nbt != null) {
                return BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).result().orElse(null);
            }
            return null;
        }
    }
}

