/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.crafting.AssemblyHaloContainer;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class AssemblyHaloItem
extends Item {
    private static final ResourceLocation glowTexture = new ResourceLocation("botania:textures/misc/glow0.png");
    private static final ItemStack craftingTable = new ItemStack((ItemLike)Blocks.CRAFTING_TABLE);
    public static final int SEGMENTS = 12;
    private static final String TAG_LAST_CRAFTING = "lastCrafting";
    private static final String TAG_STORED_RECIPE_PREFIX = "storedRecipe";
    private static final String TAG_EQUIPPED = "equipped";
    private static final String TAG_ROTATION_BASE = "rotationBase";

    public AssemblyHaloItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            int segment = AssemblyHaloItem.getSegmentLookedAt(stack, (LivingEntity)player);
            Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(world, stack, segment);
            if (segment == 0) {
                ContainerLevelAccess wp = ContainerLevelAccess.create((Level)world, (BlockPos)BlockPos.ZERO);
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInv, p) -> new AssemblyHaloContainer(windowId, playerInv, wp), stack.getHoverName()));
            } else if (recipe == null) {
                Recipe<CraftingContainer> lastRecipe = AssemblyHaloItem.getLastRecipe(world, stack);
                if (lastRecipe != null) {
                    AssemblyHaloItem.saveRecipe(stack, lastRecipe.getId(), segment);
                }
            } else {
                this.tryCraft(player, stack, segment, true);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int pos, boolean equipped) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean eqLastTick = AssemblyHaloItem.wasEquipped(stack);
        if (!equipped && living.getOffhandItem() == stack) {
            equipped = true;
        }
        if (eqLastTick != equipped) {
            AssemblyHaloItem.setEquipped(stack, equipped);
        }
        if (!equipped) {
            int angles = 360;
            int segAngles = angles / 12;
            float shift = (float)segAngles / 2.0f;
            AssemblyHaloItem.setRotationBase(stack, AssemblyHaloItem.getCheckingAngle((LivingEntity)entity) - shift);
        }
    }

    private static boolean hasRoomFor(Inventory inv, ItemStack stack) {
        Inventory dummy = new Inventory(inv.player);
        for (int i = 0; i < inv.items.size(); ++i) {
            dummy.items.set(i, (Object)((ItemStack)inv.items.get(i)).copy());
        }
        return dummy.add(stack.copy());
    }

    private static boolean canCraftHeuristic(Player player, Recipe<CraftingContainer> recipe) {
        StackedContents accounter = new StackedContents();
        player.getInventory().fillStackedContents(accounter);
        return accounter.canCraft(recipe, null);
    }

    void tryCraft(Player player, ItemStack halo, int slot, boolean particles) {
        Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(player.level(), halo, slot);
        if (recipe == null) {
            return;
        }
        CraftingMenu dummy = new CraftingMenu(-999, player.getInventory());
        CraftingContainer craftInv = (CraftingContainer)dummy.getSlot((int)1).container;
        RecipePlacer placer = new RecipePlacer((RecipeBookMenu<CraftingContainer>)dummy);
        if (!placer.place((ServerPlayer)player, recipe)) {
            return;
        }
        if (!recipe.matches((Container)craftInv, player.level())) {
            placer.clearGrid();
            return;
        }
        ItemStack result = recipe.assemble((Container)craftInv, player.level().registryAccess());
        if (!AssemblyHaloItem.hasRoomFor(player.getInventory(), result)) {
            placer.clearGrid();
            return;
        }
        player.getInventory().add(result);
        NonNullList remainingItems = recipe.getRemainingItems((Container)craftInv);
        remainingItems.forEach(s -> player.getInventory().placeItemBackInInventory(s));
        if (particles) {
            XplatAbstractions.INSTANCE.sendToTracking((Entity)player, new BotaniaEffectPacket(EffectType.HALO_CRAFT, player.getX(), player.getY(), player.getZ(), player.getId()));
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity living) {
        int segment = AssemblyHaloItem.getSegmentLookedAt(stack, living);
        if (segment == 0) {
            return false;
        }
        Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(living.level(), stack, segment);
        if (recipe != null && living.isShiftKeyDown()) {
            AssemblyHaloItem.saveRecipe(stack, null, segment);
            return true;
        }
        return false;
    }

    protected static int getSegmentLookedAt(ItemStack stack, LivingEntity living) {
        float yaw = AssemblyHaloItem.getCheckingAngle(living, AssemblyHaloItem.getRotationBase(stack));
        int angles = 360;
        int segAngles = angles / 12;
        for (int seg = 0; seg < 12; ++seg) {
            float calcAngle = (float)seg * (float)segAngles;
            if (!(yaw >= calcAngle) || !(yaw < calcAngle + (float)segAngles)) continue;
            return seg;
        }
        return -1;
    }

    private static float getCheckingAngle(LivingEntity living) {
        return AssemblyHaloItem.getCheckingAngle(living, 0.0f);
    }

    private static float getCheckingAngle(LivingEntity living, float base) {
        float angle;
        float yaw = Mth.wrapDegrees((float)living.getYRot()) + 90.0f;
        int angles = 360;
        int segAngles = angles / 12;
        float shift = segAngles / 2;
        if (yaw < 0.0f) {
            yaw = 180.0f + (180.0f + yaw);
        }
        if ((angle = 360.0f - (yaw -= 360.0f - base) + shift) < 0.0f) {
            angle = 360.0f + angle;
        }
        return angle;
    }

    @Nullable
    private static Recipe<CraftingContainer> getSavedRecipe(Level world, ItemStack halo, int position) {
        ResourceLocation id;
        String savedId = ItemNBTHelper.getString(halo, TAG_STORED_RECIPE_PREFIX + position, "");
        ResourceLocation resourceLocation = id = savedId.isEmpty() ? null : ResourceLocation.tryParse((String)savedId);
        if (position <= 0 || position >= 12 || id == null) {
            return null;
        }
        return (Recipe)BotaniaRecipeTypes.getRecipes(world, RecipeType.CRAFTING).get(id);
    }

    private static void saveRecipe(ItemStack halo, @Nullable ResourceLocation id, int position) {
        if (id == null) {
            ItemNBTHelper.removeEntry(halo, TAG_STORED_RECIPE_PREFIX + position);
        } else {
            ItemNBTHelper.setString(halo, TAG_STORED_RECIPE_PREFIX + position, id.toString());
        }
    }

    private static ItemStack getDisplayItem(Level world, ItemStack stack, int position) {
        if (position == 0) {
            return craftingTable;
        }
        if (position >= 12) {
            return ItemStack.EMPTY;
        }
        Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(world, stack, position);
        if (recipe != null) {
            return recipe.getResultItem(world.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    public static void onItemCrafted(Player player, Container inv) {
        AbstractContainerMenu container = player.containerMenu;
        if (!(container instanceof AssemblyHaloContainer) || !(inv instanceof CraftingContainer)) {
            return;
        }
        CraftingContainer cc = (CraftingContainer)inv;
        player.level().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)cc, player.level()).ifPresent(recipe -> {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (stack.isEmpty() || !(stack.getItem() instanceof AssemblyHaloItem)) continue;
                AssemblyHaloItem.rememberLastRecipe(recipe.getId(), stack);
            }
        });
    }

    private static void rememberLastRecipe(ResourceLocation recipeId, ItemStack halo) {
        ItemNBTHelper.setString(halo, TAG_LAST_CRAFTING, recipeId.toString());
    }

    @Nullable
    private static Recipe<CraftingContainer> getLastRecipe(Level world, ItemStack halo) {
        String savedId = ItemNBTHelper.getString(halo, TAG_LAST_CRAFTING, "");
        ResourceLocation id = savedId.isEmpty() ? null : ResourceLocation.tryParse((String)savedId);
        return (Recipe)BotaniaRecipeTypes.getRecipes(world, RecipeType.CRAFTING).get(id);
    }

    private static boolean wasEquipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_EQUIPPED, false);
    }

    private static void setEquipped(ItemStack stack, boolean equipped) {
        ItemNBTHelper.setBoolean(stack, TAG_EQUIPPED, equipped);
    }

    private static float getRotationBase(ItemStack stack) {
        return ItemNBTHelper.getFloat(stack, TAG_ROTATION_BASE, 0.0f);
    }

    private static void setRotationBase(ItemStack stack, float rotation) {
        ItemNBTHelper.setFloat(stack, TAG_ROTATION_BASE, rotation);
    }

    public ResourceLocation getGlowResource(ItemStack stack) {
        return glowTexture;
    }

    public static class RecipePlacer
    extends ServerPlaceRecipe<CraftingContainer> {
        public RecipePlacer(RecipeBookMenu<CraftingContainer> container) {
            super(container);
        }

        public boolean place(ServerPlayer player, @Nullable Recipe<CraftingContainer> recipe) {
            if (recipe != null) {
                boolean ret;
                this.inventory = player.getInventory();
                this.stackedContents.clear();
                player.getInventory().fillStackedContents(this.stackedContents);
                this.menu.fillCraftSlotsStackedContents(this.stackedContents);
                if (this.stackedContents.canCraft(recipe, null)) {
                    this.handleRecipeClicked(recipe, false);
                    ret = true;
                } else {
                    this.clearGrid();
                    ret = false;
                }
                player.getInventory().setChanged();
                return ret;
            }
            return false;
        }

        public void clearGrid() {
            super.clearGrid();
        }
    }

    public static class Rendering {
        public static void onRenderWorldLast(Camera camera, float partialTicks, PoseStack ms, RenderBuffers buffers) {
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack stack = PlayerHelper.getFirstHeldItemClass((LivingEntity)player, AssemblyHaloItem.class);
            if (stack.isEmpty()) {
                return;
            }
            MultiBufferSource.BufferSource bufferSource = buffers.bufferSource();
            double renderPosX = camera.getPosition().x();
            double renderPosY = camera.getPosition().y();
            double renderPosZ = camera.getPosition().z();
            ms.pushPose();
            float alpha = ((float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.2f) * 0.5f + 0.5f) * 0.4f + 0.3f;
            double posX = player.xo + (player.getX() - player.xo) * (double)partialTicks;
            double posY = player.yo + (player.getY() - player.yo) * (double)partialTicks + (double)player.getEyeHeight();
            double posZ = player.zo + (player.getZ() - player.zo) * (double)partialTicks;
            ms.translate(posX - renderPosX, posY - renderPosY, posZ - renderPosZ);
            float base = AssemblyHaloItem.getRotationBase(stack);
            int angles = 360;
            int segAngles = angles / 12;
            float shift = base - (float)segAngles / 2.0f;
            float u = 1.0f;
            float v = 0.25f;
            float s = 3.0f;
            float m = 0.8f;
            float y = v * s * 2.0f;
            float y0 = 0.0f;
            int segmentLookedAt = AssemblyHaloItem.getSegmentLookedAt(stack, (LivingEntity)player);
            AssemblyHaloItem item = (AssemblyHaloItem)stack.getItem();
            RenderType layer = RenderHelper.getHaloLayer(item.getGlowResource(stack));
            for (int seg = 0; seg < 12; ++seg) {
                ItemStack slotStack;
                boolean inside = false;
                float rotationAngle = ((float)seg + 0.5f) * (float)segAngles + shift;
                ms.pushPose();
                ms.mulPose(VecHelper.rotateY(rotationAngle));
                ms.translate(s * m, -0.75f, 0.0f);
                if (segmentLookedAt == seg) {
                    inside = true;
                }
                if (!(slotStack = AssemblyHaloItem.getDisplayItem(player.level(), stack, seg)).isEmpty()) {
                    float scale = seg == 0 ? 0.9f : 0.8f;
                    ms.scale(scale, scale, scale);
                    ms.mulPose(VecHelper.rotateY(180.0f));
                    ms.translate(seg == 0 ? 0.5f : 0.0f, seg == 0 ? -0.1f : 0.6f, 0.0f);
                    ms.mulPose(VecHelper.rotateY(90.0f));
                    Minecraft.getInstance().getItemRenderer().renderStatic(slotStack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.NO_OVERLAY, ms, (MultiBufferSource)bufferSource, player.level(), player.getId());
                }
                ms.popPose();
                ms.pushPose();
                ms.mulPose(VecHelper.rotateX(180.0f));
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                float a = alpha;
                if (inside) {
                    a += 0.3f;
                    y0 = -y;
                }
                if (seg % 2 == 0) {
                    b = 0.6f;
                    g = 0.6f;
                    r = 0.6f;
                }
                VertexConsumer buffer = bufferSource.getBuffer(layer);
                for (int i = 0; i < segAngles; ++i) {
                    Matrix4f mat = ms.last().pose();
                    float ang = (float)(i + seg * segAngles) + shift;
                    float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * s;
                    float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * s;
                    buffer.vertex(mat, xp * m, y, zp * m).color(r, g, b, a).uv(u, v).endVertex();
                    buffer.vertex(mat, xp, y0, zp).color(r, g, b, a).uv(u, 0.0f).endVertex();
                    xp = (float)Math.cos((double)(ang + 1.0f) * Math.PI / 180.0) * s;
                    zp = (float)Math.sin((double)(ang + 1.0f) * Math.PI / 180.0) * s;
                    buffer.vertex(mat, xp, y0, zp).color(r, g, b, a).uv(0.0f, 0.0f).endVertex();
                    buffer.vertex(mat, xp * m, y, zp * m).color(r, g, b, a).uv(0.0f, v).endVertex();
                }
                y0 = 0.0f;
                ms.popPose();
            }
            ms.popPose();
            bufferSource.endBatch();
        }

        public static void renderHUD(GuiGraphics gui, Player player, ItemStack stack) {
            Minecraft mc = Minecraft.getInstance();
            int slot = AssemblyHaloItem.getSegmentLookedAt(stack, (LivingEntity)player);
            if (slot == 0) {
                String name = craftingTable.getHoverName().getString();
                int l = mc.font.width(name);
                int x = mc.getWindow().getGuiScaledWidth() / 2 - l / 2;
                int y = mc.getWindow().getGuiScaledHeight() / 2 - 65;
                gui.fill(x - 6, y - 6, x + l + 6, y + 37, 0x22000000);
                gui.fill(x - 4, y - 4, x + l + 4, y + 35, 0x22000000);
                gui.renderItem(craftingTable, mc.getWindow().getGuiScaledWidth() / 2 - 8, mc.getWindow().getGuiScaledHeight() / 2 - 52);
                gui.drawString(mc.font, name, x, y, 0xFFFFFF);
            } else {
                MutableComponent label;
                Recipe<CraftingContainer> recipe = AssemblyHaloItem.getSavedRecipe(player.level(), stack, slot);
                boolean setRecipe = false;
                if (recipe == null) {
                    label = Component.translatable((String)"botaniamisc.unsetRecipe");
                    recipe = AssemblyHaloItem.getLastRecipe(player.level(), stack);
                } else {
                    label = recipe.getResultItem(player.level().registryAccess()).getHoverName();
                    setRecipe = true;
                }
                Rendering.renderRecipe(gui, (Component)label, recipe, player, setRecipe);
            }
        }

        private static void renderRecipe(GuiGraphics gui, Component label, @Nullable Recipe<CraftingContainer> recipe, Player player, boolean isSavedRecipe) {
            ItemStack recipeResult;
            Minecraft mc = Minecraft.getInstance();
            if (recipe != null && !(recipeResult = recipe.getResultItem(player.level().registryAccess())).isEmpty()) {
                int n;
                int x = mc.getWindow().getGuiScaledWidth() / 2 - 45;
                int y = mc.getWindow().getGuiScaledHeight() / 2 - 90;
                gui.fill(x - 6, y - 6, x + 90 + 6, y + 60, 0x22000000);
                gui.fill(x - 4, y - 4, x + 90 + 4, y + 58, 0x22000000);
                gui.fill(x + 66, y + 14, x + 92, y + 40, 0x22000000);
                gui.fill(x - 2, y - 2, x + 56, y + 56, 0x22000000);
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shaped = (ShapedRecipe)recipe;
                    n = shaped.getWidth();
                } else {
                    n = 3;
                }
                int wrap = n;
                for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                    Ingredient ingr = (Ingredient)recipe.getIngredients().get(i);
                    if (ingr == Ingredient.EMPTY) continue;
                    ItemStack stack = ingr.getItems()[ClientTickHandler.ticksInGame / 20 % ingr.getItems().length];
                    int xpos = x + i % wrap * 18;
                    int ypos = y + i / wrap * 18;
                    gui.fill(xpos, ypos, xpos + 16, ypos + 16, 0x22000000);
                    gui.renderItem(stack, xpos, ypos);
                }
                gui.renderItem(recipeResult, x + 72, y + 18);
                gui.renderItemDecorations(mc.font, recipeResult, x + 72, y + 18);
            }
            int yoff = 110;
            if (isSavedRecipe && recipe != null && !AssemblyHaloItem.canCraftHeuristic(player, recipe)) {
                String warning = ChatFormatting.RED + I18n.get((String)"botaniamisc.cantCraft", (Object[])new Object[0]);
                gui.drawCenteredString(mc.font, warning, mc.getWindow().getGuiScaledWidth() / 2, mc.getWindow().getGuiScaledHeight() / 2 - yoff, 0xFFFFFF);
                yoff += 12;
            }
            gui.drawCenteredString(mc.font, label, mc.getWindow().getGuiScaledWidth() / 2, mc.getWindow().getGuiScaledHeight() / 2 - yoff, 0xFFFFFF);
        }
    }
}

