/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.item.BotaniaItems;

public class ManaStormEntity
extends Entity {
    private static final String TAG_TIME = "time";
    private static final String TAG_BURST_COLOR = "burstColor";
    private static final String TAG_BURSTS_FIRED = "burstsFired";
    private static final String TAG_DEATH_TIME = "deathTime";
    public static final int TOTAL_BURSTS = 250;
    public static final int DEATH_TIME = 200;
    public int liveTime;
    public int burstColor;
    public int burstsFired;
    public int deathTime;

    public ManaStormEntity(EntityType<ManaStormEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData() {
    }

    public void tick() {
        super.tick();
        ++this.liveTime;
        int diffTime = Math.max(1, 30 - (int)((float)this.liveTime / 45.0f));
        if (this.burstsFired < 250 && this.liveTime % diffTime == 0) {
            if (!this.level().isClientSide) {
                this.spawnBurst();
            }
            ++this.burstsFired;
        }
        if (this.burstsFired >= 250) {
            ++this.deathTime;
            if (this.deathTime >= 200) {
                this.discard();
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 8.0f, true, Level.ExplosionInteraction.BLOCK);
            }
        }
    }

    private void spawnBurst() {
        ManaBurstEntity burst = (ManaBurstEntity)BotaniaEntities.MANA_BURST.create(this.level());
        burst.setPos(this.getX(), this.getY(), this.getZ());
        float motionModifier = 0.5f;
        burst.setColor(this.burstColor);
        burst.setMana(300);
        burst.setStartingMana(850);
        burst.setMinManaLoss(50);
        burst.setManaLossPerTick(2.5f);
        burst.setGravity(0.0f);
        burst.setSourceLens(new ItemStack((ItemLike)BotaniaItems.lensStorm));
        Vec3 motion = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).normalize().scale((double)motionModifier);
        burst.setDeltaMovement(motion);
        this.level().addFreshEntity((Entity)burst);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag cmp) {
        this.liveTime = cmp.getInt(TAG_TIME);
        this.burstColor = cmp.getInt(TAG_BURST_COLOR);
        this.burstsFired = cmp.getInt(TAG_BURSTS_FIRED);
        this.deathTime = cmp.getInt(TAG_DEATH_TIME);
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag cmp) {
        cmp.putInt(TAG_TIME, this.liveTime);
        cmp.putInt(TAG_BURST_COLOR, this.burstColor);
        cmp.putInt(TAG_BURSTS_FIRED, this.burstsFired);
        cmp.putInt(TAG_DEATH_TIME, this.deathTime);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

