/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class LifeImbuerBlockEntity
extends BotaniaBlockEntity
implements ManaReceiver {
    private static final String TAG_MANA = "mana";
    private static final int MAX_MANA = 160;
    private int mana = 0;

    public LifeImbuerBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.SPAWNER_CLAW, pos, state);
    }

    public static void onSpawnerNearPlayer(Level level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockEntity be;
        if (!level.getBlockState(pos).is(Blocks.SPAWNER)) {
            return;
        }
        BlockPos up = pos.above();
        if (level.getBlockState(up).is(BotaniaBlocks.spawnerClaw) && (be = level.getBlockEntity(pos.above())) instanceof LifeImbuerBlockEntity) {
            LifeImbuerBlockEntity claw = (LifeImbuerBlockEntity)be;
            if (claw.mana > 5) {
                claw.receiveMana(-6);
                if (level.isClientSide && Math.random() > 0.5) {
                    WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, 0.6f - (float)Math.random() * 0.3f, 0.1f, 0.6f - (float)Math.random() * 0.3f, 2.0f);
                    level.addParticle((ParticleOptions)data, (double)up.getX() + 0.3 + Math.random() * 0.5, (double)up.getY() - 0.3 + Math.random() * 0.25, (double)up.getZ() + Math.random(), 0.0, (double)(-(-0.025f - 0.005f * (float)Math.random())), 0.0);
                }
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.putInt(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.getInt(TAG_MANA);
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 160;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(480, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }
}

