/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import org.jetbrains.annotations.NotNull;

public abstract class BotaniaRecipeProvider
implements DataProvider {
    private final PackOutput.PathProvider recipePathProvider;
    private final PackOutput.PathProvider advancementPathProvider;

    public BotaniaRecipeProvider(PackOutput packOutput) {
        this.recipePathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "recipes");
        this.advancementPathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "advancements");
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        HashSet checkDuplicates = Sets.newHashSet();
        ArrayList output = new ArrayList();
        this.buildRecipes(recipe -> {
            if (!checkDuplicates.add(recipe.getId())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.getId());
            }
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)recipe.serializeRecipe(), (Path)this.recipePathProvider.json(recipe.getId())));
            JsonObject advancement = recipe.serializeAdvancement();
            if (advancement != null) {
                output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)advancement, (Path)this.advancementPathProvider.json(recipe.getAdvancementId())));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected abstract void buildRecipes(Consumer<FinishedRecipe> var1);
}

