/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.integration.shared.LocaleHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.FilterHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;

public class ManaseerMonocleItem
extends BaubleItem
implements CosmeticBauble {
    public ManaseerMonocleItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.translatable((String)"botaniamisc.cosmeticBauble").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        super.appendHoverText(stack, world, tooltip, flags);
    }

    public static boolean hasMonocle(LivingEntity living) {
        return !EquipmentHandler.findOrEmpty(stack -> {
            if (!stack.isEmpty()) {
                Item item = stack.getItem();
                if (stack.is(BotaniaTags.Items.BURST_VIEWERS)) {
                    return true;
                }
                if (item instanceof CosmeticAttachable) {
                    CosmeticAttachable attach = (CosmeticAttachable)item;
                    ItemStack cosmetic = attach.getCosmeticItem((ItemStack)stack);
                    return !cosmetic.isEmpty() && cosmetic.is(BotaniaTags.Items.BURST_VIEWERS);
                }
            }
            return false;
        }, living).isEmpty();
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.head.translateAndRotate(ms);
            ms.translate(0.15, -0.2, -0.25);
            ms.scale(0.3f, -0.3f, -0.3f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, ms, buffers, living.level(), living.getId());
        }
    }

    public static class Hud {
        private static final int MAX_CONTENTS_COLUMNS = 9;
        private static final int MAX_CONTENTS_ROWS = 3;
        public static final int TEXT_ROW_HEIGHT = 12;

        public static void render(GuiGraphics gui, Player player) {
            EntityHitResult ehr;
            BlockHitResult bhr;
            Minecraft mc = Minecraft.getInstance();
            HitResult hitResult = mc.hitResult;
            if (hitResult instanceof BlockHitResult && (bhr = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK) {
                Hud.renderBlockInfo(gui, bhr, mc, player.level());
            } else if (hitResult instanceof EntityHitResult && (ehr = (EntityHitResult)hitResult).getType() == HitResult.Type.ENTITY) {
                Hud.renderEntityInfo(gui, ehr, mc);
            }
        }

        private static void renderEntityInfo(GuiGraphics gui, EntityHitResult hitResult, Minecraft mc) {
            ItemFrame frame;
            Entity entity = hitResult.getEntity();
            if (entity instanceof ItemFrame && !(frame = (ItemFrame)entity).getItem().isEmpty()) {
                ItemStack frameItem = frame.getItem();
                List<ItemStack> contentItems = FilterHelper.getFilterStacks(frameItem);
                if (contentItems.isEmpty() || contentItems.size() == 1 && ItemStack.isSameItemSameTags((ItemStack)frameItem, (ItemStack)contentItems.get(0))) {
                    return;
                }
                int x = mc.getWindow().getGuiScaledWidth() / 2 + 15;
                int y = mc.getWindow().getGuiScaledHeight() / 2 - 24;
                int maxWidth = mc.getWindow().getGuiScaledWidth() - x - 30;
                MutableComponent itemName = Component.empty().append(frameItem.getHoverName()).withStyle(frameItem.getRarity().color);
                if (frameItem.hasCustomHoverName()) {
                    itemName.withStyle(ChatFormatting.ITALIC);
                }
                MutableComponent text = Component.translatable((String)"botaniamisc.monocle.frame.contains", (Object[])new Object[]{itemName});
                List lines = mc.font.split((FormattedText)text, maxWidth);
                int textWidth = lines.stream().mapToInt(arg_0 -> ((Font)mc.font).width(arg_0)).max().orElseThrow();
                int textYOffset = (lines.size() - 1) * 12;
                int contentsWidth = Math.min(9, contentItems.size()) * 18;
                int contentsHeight = Math.min(4, (contentItems.size() - 1) / 9 + 1) * 18;
                RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + Math.max(textWidth, contentsWidth) + 24, y + textYOffset + contentsHeight + 20);
                gui.renderItem(frameItem, x, y);
                int textRow = 0;
                for (FormattedCharSequence line : lines) {
                    gui.drawString(mc.font, line, x + 20, y + 12 * textRow + 4, 0xFFFFFF);
                    ++textRow;
                }
                int row = 1;
                int column = 0;
                for (ItemStack contentItem : contentItems) {
                    if (++column > 9) {
                        column = 1;
                        if (++row > 3) break;
                    }
                    gui.renderItem(contentItem, x + 18 * column, y + 18 * row + textYOffset);
                    gui.renderItemDecorations(mc.font, contentItem, x + 18 * column, y + 18 * row + textYOffset);
                }
                if (row > 3) {
                    MutableComponent remainingItemsHint = Component.translatable((String)"botaniamisc.monocle.frame.additional_stacks", (Object[])new Object[]{contentItems.size() - 27});
                    gui.drawString(mc.font, (Component)remainingItemsHint, x + 24, y + 18 * row + 6 + textYOffset, 0xFFFFFF);
                }
            }
        }

        private static void renderBlockInfo(GuiGraphics gui, BlockHitResult hitResult, Minecraft mc, Level level) {
            MutableComponent text;
            ItemStack dispStack;
            BlockPos pos = hitResult.getBlockPos();
            BlockState state = level.getBlockState(pos);
            if (state.hasProperty((Property)BlockStateProperties.POWER)) {
                dispStack = new ItemStack((ItemLike)state.getBlock());
                text = Component.literal((String)((Integer)state.getValue((Property)BlockStateProperties.POWER)).toString()).withStyle(ChatFormatting.RED);
            } else if (state.is(Blocks.REPEATER)) {
                dispStack = new ItemStack((ItemLike)Blocks.REPEATER);
                text = Component.translatable((String)"botaniamisc.monocle.repeater.delay", (Object[])new Object[]{LocaleHelper.formatAsDecimalFraction(0.1f * (float)((Integer)state.getValue((Property)RepeaterBlock.DELAY)).intValue(), 1)});
            } else if (state.is(Blocks.COMPARATOR)) {
                dispStack = new ItemStack((ItemLike)Blocks.COMPARATOR);
                text = Component.translatable((String)("botaniamisc.monocle.comparator." + ((ComparatorMode)state.getValue((Property)ComparatorBlock.MODE)).getSerializedName()));
            } else {
                return;
            }
            int x = mc.getWindow().getGuiScaledWidth() / 2 + 15;
            int y = mc.getWindow().getGuiScaledHeight() / 2 - 8;
            int textWidth = mc.font.width(text.getVisualOrderText());
            RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + textWidth + 24, y + 20);
            gui.renderItem(dispStack, x, y);
            gui.drawString(mc.font, (Component)text, x + 20, y + 4, 0xFFFFFF);
        }
    }
}

