/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class SidedVanillaCorporeaNode
extends AbstractCorporeaNode {
    private final WorldlyContainer inv;
    private final Direction side;

    public SidedVanillaCorporeaNode(Level world, BlockPos pos, CorporeaSpark spark, WorldlyContainer inv, Direction side) {
        super(world, pos, spark);
        this.inv = inv;
        this.side = side;
    }

    @Override
    public List<ItemStack> countItems(CorporeaRequest request) {
        return this.examineInventory(request, false);
    }

    @Override
    public List<ItemStack> extractItems(CorporeaRequest request) {
        return this.examineInventory(request, true);
    }

    protected List<ItemStack> examineInventory(CorporeaRequest request, boolean doit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int[] slots = this.inv.getSlotsForFace(this.side);
        for (int i = slots.length - 1; i >= 0; --i) {
            int slot = slots[i];
            ItemStack stack = this.inv.getItem(slot);
            boolean canTake = this.inv.canTakeItemThroughFace(slot, stack, this.side);
            if (!canTake || !request.getMatcher().test(stack)) continue;
            request.trackFound(stack.getCount());
            int rem = Math.min(stack.getCount(), request.getStillNeeded() == -1 ? stack.getCount() : request.getStillNeeded());
            if (rem <= 0) continue;
            request.trackSatisfied(rem);
            ItemStack copy = stack.copyWithCount(rem);
            if (doit) {
                if (this.getSpark().isCreative()) {
                    builder.add((Object)copy);
                } else {
                    builder.addAll(SidedVanillaCorporeaNode.breakDownBigStack(this.inv.removeItem(i, rem)));
                    this.inv.setChanged();
                }
                this.getSpark().onItemExtracted(copy);
                request.trackExtracted(rem);
                continue;
            }
            builder.add((Object)copy);
        }
        return builder.build();
    }
}

