/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.RunicAltarRecipe;
import vazkii.botania.common.helper.ItemNBTHelper;

public class HeadRecipe
extends RunicAltarRecipe {
    private static final Pattern PROFILE_PATTERN = Pattern.compile("(?<base64>[A-Za-z0-9+/]{100,}={0,2})|(?<url>(?=\\S{50,})https?://(?!bugs|education|feedback)\\w+\\.(?:minecraft\\.net|mojang\\.com)/\\S+)|(?<hash>[0-9a-f]{64})");
    public static final String TEXTURE_URL_BASE = "https://textures.minecraft.net/texture/";
    private static final Supplier<Gson> gson = Suppliers.memoize(() -> new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create());
    private static final GameProfile PROFILE_VALID_RESULT = new GameProfile(null, "valid");
    private static final LoadingCache<String, UUID> GENERATED_UUID_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, UUID>(){

        @NotNull
        public UUID load(@NotNull String key) {
            return UUID.nameUUIDFromBytes(key.getBytes(StandardCharsets.UTF_8));
        }
    });

    public HeadRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
        super(id, output, mana, inputs);
    }

    @Override
    public boolean matches(Container inv, @NotNull Level world) {
        boolean matches = super.matches(inv, world);
        boolean foundName = false;
        if (matches) {
            ItemStack stack;
            for (int i = 0; i < inv.getContainerSize() && !(stack = inv.getItem(i)).isEmpty(); ++i) {
                if (stack.is(Items.NAME_TAG)) {
                    if (foundName || !stack.hasCustomHoverName() || stack.getHoverName().getString().isBlank()) {
                        return false;
                    }
                    foundName = true;
                    continue;
                }
                if (!stack.is(Items.WRITTEN_BOOK)) continue;
                if (foundName || !WrittenBookItem.makeSureTagIsValid((CompoundTag)stack.getTag()) || this.parseProfileFromBook(stack, true) == null) {
                    return false;
                }
                foundName = true;
            }
        }
        return matches;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull Container inv, @NotNull RegistryAccess registries) {
        ItemStack stack = this.getResultItem(registries).copy();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack ingr = inv.getItem(i);
            if (ingr.is(Items.NAME_TAG)) {
                ItemNBTHelper.setString(stack, "SkullOwner", ingr.getHoverName().getString());
                break;
            }
            if (!ingr.is(Items.WRITTEN_BOOK)) continue;
            GameProfile profile = this.parseProfileFromBook(ingr, false);
            ItemNBTHelper.setCompound(stack, "SkullOwner", NbtUtils.writeGameProfile((CompoundTag)new CompoundTag(), (GameProfile)profile));
            break;
        }
        return stack;
    }

    private GameProfile parseProfileFromBook(ItemStack stack, boolean validateOnly) {
        CompoundTag tag = stack.getTag();
        String name = tag.getString("title");
        if (name.isBlank()) {
            return null;
        }
        ListTag pages = tag.getList("pages", 8);
        int maxPages = Math.min(2, pages.size());
        for (int i = 0; i < maxPages; ++i) {
            Object textureUrl;
            String pageJson = pages.getString(i);
            String pageText = HeadRecipe.parsePage(pageJson);
            Matcher matcher = PROFILE_PATTERN.matcher(pageText);
            if (!matcher.matches()) continue;
            String hash = matcher.group("hash");
            if (hash != null) {
                textureUrl = TEXTURE_URL_BASE + hash;
            } else {
                String url = matcher.group("url");
                if (url != null) {
                    try {
                        URL validUrl = new URL(url);
                        textureUrl = validUrl.toString();
                    }
                    catch (Exception e) {
                        return null;
                    }
                } else {
                    String base64 = matcher.group("base64");
                    if (base64 != null) {
                        try {
                            String json = new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
                            MinecraftTexturesPayload result = (MinecraftTexturesPayload)((Gson)gson.get()).fromJson(json, MinecraftTexturesPayload.class);
                            MinecraftProfileTexture skinTexture = (MinecraftProfileTexture)result.getTextures().get(MinecraftProfileTexture.Type.SKIN);
                            String skinTextureUrl = skinTexture.getUrl();
                            if (!PROFILE_PATTERN.matcher(skinTextureUrl).matches()) {
                                return null;
                            }
                            URL validUrl = new URL(skinTextureUrl);
                            textureUrl = validUrl.toString();
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
            }
            if (validateOnly) {
                return PROFILE_VALID_RESULT;
            }
            String profileTextureJson = "{textures:{SKIN:{url:\"%s\"}}}".formatted(textureUrl);
            String propertyBase64 = Base64.getEncoder().encodeToString(profileTextureJson.getBytes(StandardCharsets.UTF_8));
            GameProfile profile = new GameProfile((UUID)GENERATED_UUID_CACHE.getUnchecked((Object)propertyBase64), name);
            profile.getProperties().put((Object)"textures", (Object)new Property("Value", propertyBase64));
            return profile;
        }
        return null;
    }

    private static String parsePage(String pageJson) {
        try {
            MutableComponent formattedtext = Component.Serializer.fromJson((String)pageJson);
            return formattedtext != null ? formattedtext.getString() : pageJson;
        }
        catch (Exception exception) {
            return pageJson;
        }
    }

    public static class Serializer
    implements RecipeSerializer<HeadRecipe> {
        @NotNull
        public HeadRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"output"));
            int mana = GsonHelper.getAsInt((JsonObject)json, (String)"mana");
            JsonArray ingrs = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.fromJson((JsonElement)e));
            }
            return new HeadRecipe(id, output, mana, inputs.toArray(new Ingredient[0]));
        }

        public HeadRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.readVarInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.readItem();
            int mana = buf.readVarInt();
            return new HeadRecipe(id, output, mana, inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull HeadRecipe recipe) {
            BotaniaRecipeTypes.RUNE_SERIALIZER.toNetwork(buf, (Recipe)recipe);
        }
    }
}

